import fetch from 'node-fetch';
import WordSearch from '@sbj42/word-search-generator';
import QRCode from 'qrcode';

export default {
	id: 'helpers',
	handler: (router, context) => {
		const { services, database, getSchema, env, logger, emitter } = context;
		const { ItemsService, UsersService, AuthenticationService } = services;

		function getRandomSubset(array, subsetSize) {
			// Make a copy of the array to avoid modifying the original array
			let shuffled = array.slice();

			// Fisher-Yates shuffle algorithm
			for (let i = shuffled.length - 1; i > 0; i--) {
				const j = Math.floor(Math.random() * (i + 1));
				[shuffled[i], shuffled[j]] = [shuffled[j], shuffled[i]];
			}

			// Return the first 'subsetSize' elements from the shuffled array
			return shuffled.slice(0, subsetSize);
		}

		router.get('/build', async (req, res, next) => {
			//A user submits a team id, 
			//we validate the team exists and is for an upcomming (game start time is in the future)
			//the related players record is deleted

			const wizzardService = new ItemsService("add_adventure_wizzard", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const adventuresService = new ItemsService("adventures", {
				schema: req.schema,
				accountability: req.accountability,
			});

			const teamsService = new ItemsService("teams", {
				schema: req.schema,
				accountability: req.accountability,
			});

			const stagesService = new ItemsService("stages", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const triviaquizService = new ItemsService("triviaquiz", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const sudokuService = new ItemsService("sudoku", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const connectdotsService = new ItemsService("connectdots", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const wordsearchService = new ItemsService("wordsearch", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const fifteenupService = new ItemsService("fifteenup", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const riddlesService = new ItemsService("riddles", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const quickmathService = new ItemsService("quickmath", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const qrcodeService = new ItemsService("qrcode", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const spotthedifferenceService = new ItemsService("spotthedifference", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const stagesTriviaService = new ItemsService("stages_triviaquiz", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const stagesSudokuService = new ItemsService("stages_sudoku", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const stagesRiddlesService = new ItemsService("stages_riddles", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const stagesConnectdotsService = new ItemsService("stages_connectdots", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const stagesFifteenupService = new ItemsService("stages_fifteenup", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const stagesWordsearchService = new ItemsService("stages_wordsearch", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const stagesQuickmathService = new ItemsService("stages_quickmath", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const stagesSpotthedifferenceService = new ItemsService("stages_spotthedifference", {
				schema: req.schema,
				accountability: req.accountability,
			});
			const stagesQrcodeService = new ItemsService("stages_qrcode", {
				schema: req.schema,
				accountability: req.accountability,
			});

			try {
				const { id } = req.query
				let wizzard = await wizzardService.readOne(id)

				const adventure = await adventuresService.createOne({
					title: wizzard.title,
					start_date_and_time: wizzard.start_date_and_time,
					finish_date_and_time: wizzard.finish_date_and_time
				})

				for (let i = 0; i < wizzard.number_of_teams; i++) {
					await teamsService.createOne({
						adventure: adventure,
						name: `${adventure}_${i}`
					})
				}

				for (const wizzard_stage of wizzard.stages) {
					let stage = await stagesService.createOne({
						title: wizzard_stage.name,
						adventure: adventure
					})

					let repo_ids = []
					if (wizzard_stage.trivia != 'none') {
						if (wizzard_stage.trivia === 'mixed') {
							repo_ids = await triviaquizService.readByQuery({
								fields: ['id'],
								limit: -1,
							})
						} else {
							repo_ids = await triviaquizService.readByQuery({
								filter: {
									category: {
										_eq: wizzard_stage.trivia
									}
								},
								fields: ['id'],
								limit: -1,
							})
						}

						const randomSubset = getRandomSubset(repo_ids, 10);
						for (let i = 0; i < randomSubset.length; i++) {
							await stagesTriviaService.createOne({
								stages_id: stage,
								triviaquiz_id: randomSubset[i]['id']
							})
						}
					}

					if (wizzard_stage.sudoku != 'none') {
						repo_ids = await sudokuService.readByQuery({
							filter: {
								difficulty: {
									_eq: wizzard_stage.sudoku
								}
							},
							fields: ['id'],
							limit: -1,
						})

						const randomSubset = getRandomSubset(repo_ids, 1);
						await stagesSudokuService.createOne({
							stages_id: stage,
							sudoku_id: randomSubset[0]['id']
						})
					}

					if (wizzard_stage.connectdots != 'none') {
						repo_ids = await connectdotsService.readByQuery({
							filter: {
								difficulty: {
									_eq: wizzard_stage.connectdots
								}
							},
							fields: ['id'],
							limit: -1,
						})

						const randomSubset = getRandomSubset(repo_ids, 1);
						await stagesConnectdotsService.createOne({
							stages_id: stage,
							connectdots_id: randomSubset[0]['id']
						})
					}

					if (wizzard_stage.wordsearch != 'none') {
						repo_ids = await wordsearchService.readByQuery({
							filter: {
								difficulty: {
									_eq: wizzard_stage.wordsearch
								}
							},
							fields: ['id'],
							limit: -1,
						})

						const randomSubset = getRandomSubset(repo_ids, 1);
						await stagesWordsearchService.createOne({
							stages_id: stage,
							wordsearch_id: randomSubset[0]['id']
						})
					}

					if (wizzard_stage.fifteenup != 'none') {
						repo_ids = await fifteenupService.readByQuery({
							filter: {
								difficulty: {
									_eq: wizzard_stage.fifteenup
								}
							},
							fields: ['id'],
							limit: -1,
						})

						const randomSubset = getRandomSubset(repo_ids, 1);
						await stagesFifteenupService.createOne({
							stages_id: stage,
							fifteenup_id: randomSubset[0]['id']
						})
					}

					if (wizzard_stage.riddles != 'none') {
						repo_ids = await riddlesService.readByQuery({
							// filter: {
							// 	difficulty: {
							// 		_eq: wizzard_stage.fifteenup
							// 	}
							// },
							fields: ['id'],
							limit: -1,
						})

						const randomSubset = getRandomSubset(repo_ids, 1);
						for (let i = 0; i < randomSubset.length; i++) {
							await stagesRiddlesService.createOne({
								stages_id: stage,
								riddles_id: randomSubset[i]['id']
							})
						}
					}

					if (wizzard_stage.qrcode != 'no') {
						repo_ids = await qrcodeService.readByQuery({
							fields: ['id'],
							limit: -1,
						})

						const randomSubset = getRandomSubset(repo_ids, 1);
						for (let i = 0; i < randomSubset.length; i++) {
							await stagesQrcodeService.createOne({
								stages_id: stage,
								qrcode_id: randomSubset[i]['id']
							})
						}
					}

					if (wizzard_stage.quickmath != 'none') {
						repo_ids = await quickmathService.readByQuery({
							fields: ['id'],
							limit: -1,
						})
						const randomSubset = getRandomSubset(repo_ids, 10);
						for (let i = 0; i < randomSubset.length; i++) {
							await stagesQuickmathService.createOne({
								stages_id: stage,
								quickmath_id: randomSubset[i]['id']
							})
						}
					}

					if (wizzard_stage.spotthedifference != 'none') {
						repo_ids = await spotthedifferenceService.readByQuery({
							filter: {
								difficulty: {
									_eq: wizzard_stage.spotthedifference
								}
							},
							fields: ['id'],
							limit: -1,
						})

						const randomSubset = getRandomSubset(repo_ids, 1);
						await stagesSpotthedifferenceService.createOne({
							stages_id: stage,
							spotthedifference_id: randomSubset[0]['id']
						})
					}

				}
				res.status(200).json({
					wizzard: wizzard,
					newadventure: adventure
				});
			} catch (error) {
				res.status(500).json({
					success: false,
					message: error.message,
				})
			}
		});

		router.get('/fetch-sudoku', async (req, res) => {
			const itemsService = new ItemsService('sudoku', {
				schema: req.schema,
				accountability: req.accountability,
			});
			try {
				let allSudokuGames = [];

				// Fetch the Sudoku games 10 times
				for (let i = 0; i < 10; i++) {
					const response = await fetch('https://sudoku-api.vercel.app/api/dosuku?query={newboard(limit:5){grids{value,solution,difficulty},results,message}}');
					const data = await response.json();

					if (!data.newboard || !data.newboard.grids) {
						throw new ServiceUnavailableException('Invalid API response');
					}

					const sudokuGames = data.newboard.grids.map(grid => ({
						difficulty: grid.difficulty,
						value: grid.value,
						solution: grid.solution,
					}));

					allSudokuGames = allSudokuGames.concat(sudokuGames);
				}

				// Get all existing Sudoku games to avoid duplicates
				const existingGames = await itemsService.readByQuery({
					fields: ['value']
				});

				const existingValues = new Set(existingGames.map(game => game.value));

				// Filter out duplicates
				const uniqueSudokuGames = allSudokuGames.filter(game => !existingValues.has(game.value));

				// Insert unique games into the collection
				for (const game of uniqueSudokuGames) {
					await itemsService.createOne(game);
				}

				res.json({
					success: true,
					message: `Fetched and stored ${uniqueSudokuGames.length} unique Sudoku games successfully`,
				});

			} catch (error) {
				res.status(500).json({
					success: false,
					message: 'Failed to fetch and store Sudoku games',
				})
			}
		});

		router.get('/generate-quickmath', async (req, res) => {
			const itemsService = new ItemsService('quickmath', {
				schema: req.schema,
				accountability: req.accountability,
			});
			let equations = [];

			const operations = ['+', '-'];

			function getRandomOperand() {
				return Math.floor(Math.random() * 21); // Random number between 0 and 100
			}
			function getHiddenOperand() {
				return Math.floor(Math.random() * 4); // Random number between 0 and 3
			}

			function getRandomOperation() {
				return operations[Math.floor(Math.random() * operations.length)]; // Randomly selects '+' or '-'
			}

			for (let i = 0; i < 1000; i++) {
				const operand1 = getRandomOperand();
				const operand2 = getRandomOperand();
				const operand3 = getRandomOperand();
				const operation1 = getRandomOperation();
				const operation2 = getRandomOperation();

				let equation = `${operand1} ${operation1} ${operand2} ${operation2} ${operand3}`;
				const value = eval(equation);

				const hiddenOperand = getHiddenOperand()
				if (hiddenOperand == 0){
					equations.push({
						equation: `? ${operation1} ${operand2} ${operation2} ${operand3} = ${value}`,
						missing_value: operand1
					})
				} else if (hiddenOperand == 1){
					equations.push({
						equation: `${operand1} ${operation1} ? ${operation2} ${operand3} = ${value}`,
						missing_value: operand2
					})
				} else if (hiddenOperand == 2) {
					equations.push({
						equation: `${operand1} ${operation1} ${operand2} ${operation2} ? = ${value}`,
						missing_value: operand3
					})
				} else if (hiddenOperand == 3) {
					equations.push({
						equation: `${operand1} ${operation1} ${operand2} ${operation2} ${operand3} = ?`,
						missing_value: value
					})
				}		
			}
			let result = await itemsService.createMany(equations);

			res.json({
				success: true,
				message: `${equations.length} quickmath equations created successfully`,
			});
			
		});

		function getWordsOfMaxLength(words, maxLength, count) {
			// Filter words by the specified maximum length
			const filteredWords = words.filter(word => word.length <= maxLength);

			// Select the first 'count' words from the filtered list
			return filteredWords.slice(0, count);
		}

		function sanitizeText(text) {
			if (typeof text !== 'string') return text;
			return text
			return text
				.replace(/\\/g, '\\\\')  // Escape backslashes
				.replace(/"/g, '\\"')    // Escape double quotes
				.replace(/'/g, "\\'")    // Escape single quotes
				.replace(/\n/g, '\\n')   // Escape newlines
				.replace(/\r/g, '\\r')   // Escape carriage returns
				.replace(/\t/g, '\\t')   // Escape tabs
				.replace(/\b/g, '\\b')   // Escape backspaces
				.replace(/\f/g, '\\f')   // Escape form feeds
				.replace(/[\u0000-\u0019]+/g, ""); // Remove non-printable ASCII characters
		}

		router.get('/fetch-wordsearch', async (req, res) => {

			const wstypes = [
				{
					width: 7,
					height: 7,
					difficulty: 'Easy',
					maxLength: 6,
					count: 6,
					diagonals: false,
				},
				{
					width: 11,
					height: 11,
					difficulty: 'Medium',
					maxLength: 8,
					count: 12,
					diagonals: false,
				},
				{
					width: 15,
					height: 15,
					difficulty: 'Hard',
					maxLength: 10,
					count: 18,
					diagonals: false,
				},
			]
			try {
				const itemsService = new ItemsService('bank_word_search', {
					schema: req.schema,
					accountability: req.accountability,
				});

				let allWordSearchGames = [];
				for (const wstype of wstypes) {
					// Fetch words from Random Word API and generate Word Search games 10 times
					for (let i = 0; i < 200; i++) {
						const response = await fetch('https://random-word-api.herokuapp.com/word?number=100&lang=en');
						const words = await response.json();

						if (!words || words.length === 0) {
							throw new ServiceUnavailableException('Failed to fetch words from API');
						}
						const selectedWords = getWordsOfMaxLength(words, wstype.maxLength, wstype.count);
						if (!selectedWords || selectedWords.length < wstype.count) {
							throw new ServiceUnavailableException('Failed to find enough words');
						}
						const puzzle = WordSearch.generate({
							words: selectedWords,
							width: wstype.width,
							height: wstype.height,
							diagonals: wstype.diagonals,
						});
						// Convert the flat list of characters into a grid
						// const grid = [];
						// for (let row = 0; row < wstype.width; row++) {
						// 	const start = row * wstype.width;
						// 	const end = start + width;
						// 	grid.push(puzzle.grid.slice(start, end).join(''));
						// }
						const wordSearchGame = {
							words: puzzle.words,
							// grid: puzzle.grid.map(row => row.join('')),
							grid: puzzle.grid,
							difficulty: wstype.difficulty, // example difficulty
						};

						allWordSearchGames.push(wordSearchGame);
					}
				}

				// Insert unique games into the collection
				for (const game of allWordSearchGames) {
					await itemsService.createOne(game);
				}

				res.json({
					success: true,
					message: `Generated and stored ${allWordSearchGames.length} unique Word Search games successfully`,
				});
			} catch (error) {
				console.error(error);
				res.status(500).json({
					success: false,
					message: 'Failed to fetch and store Word Search games',
					error: error.message,
				});
			}
		});

		router.get('/fetch-trivia', async (req, res) => {
			try {
				const itemsService = new ItemsService('triviaquiz', {
					schema: req.schema,
					accountability: req.accountability,
				});

				let allTriviaQuestions = [];

				// Fetch Trivia questions 10 times to get a sufficient number of questions
				for (let i = 0; i < 1000; i++) {

					try {
						const response = await fetch('https://the-trivia-api.com/v2/questions');
						const data = await response.json();

						if (!data || !Array.isArray(data)) {
							throw new ServiceUnavailableException('Failed to fetch questions from API');
						}

						const triviaQuestions = data.map(question => ({
							question: sanitizeText(question.question.text),
							correct_answer: sanitizeText(question.correctAnswer),
							incorrect_answers: question.incorrectAnswers.map(answer => sanitizeText(answer)),
							category: question.category,
							difficulty: question.difficulty,
							is_niche: false
						}));

						allTriviaQuestions = allTriviaQuestions.concat(triviaQuestions);
					} catch (error) {
						// console.error(error);
						// res.status(500).json({
						// 	success: false,
						// 	data: response,
						// 	error: error
						// });
					}
					// Map API response to the desired format
				}

				// Get all existing trivia questions to avoid duplicates
				const existingQuestions = await itemsService.readByQuery({
					fields: ['question']
				});

				const existingQuestionTexts = new Set(existingQuestions.map(q => q.question));

				// Filter out duplicates
				const uniqueTriviaQuestions = allTriviaQuestions.filter(q => !existingQuestionTexts.has(q.question));

				// Insert unique questions into the collection
				for (const question of uniqueTriviaQuestions) {
					try {
						await itemsService.createOne(question);
					} catch (error) {
						// Ignore
					}
				}

				res.json({
					success: true,
					message: `Fetched and stored ${uniqueTriviaQuestions.length} unique trivia questions successfully`,
				});
			} catch (error) {
				console.error(error);
				res.status(500).json({
					success: false,
					message: 'Failed to fetch and store trivia questions',
					error: error.message
				});
			}
		});

		router.get('/fetch-math-trivia', async (req, res) => {
			try {
				const itemsService = new ItemsService('triviaquiz', {
					schema: req.schema,
					accountability: req.accountability,
				});

				let allTriviaQuestions = [];

				// Fetch Trivia questions 10 times to get a sufficient number of questions
				for (let i = 0; i < 100; i++) {

					try {
						const response = await fetch('https://opentdb.com/api.php?amount=10&category=19&type=multiple');
						const data = await response.results.json();

						if (!data || !Array.isArray(data)) {
							throw new ServiceUnavailableException('Failed to fetch questions from API');
						}

						const triviaQuestions = data.map(question => ({
							question: question.question,
							correct_answer: question.correct_answer,
							incorrect_answers: question.incorrect_answers,
							category: 'mathematics',
							is_niche: false,
							difficulty: question.difficulty,
						}));

						allTriviaQuestions = allTriviaQuestions.concat(triviaQuestions);
					} catch (error) {
						// console.error(error);
						// res.status(500).json({
						// 	success: false,
						// 	data: response,
						// 	error: error
						// });
					}
					// Map API response to the desired format
				}

				// Get all existing trivia questions to avoid duplicates
				const existingQuestions = await itemsService.readByQuery({
					fields: ['question']
				});

				const existingQuestionTexts = new Set(existingQuestions.map(q => q.question));

				// Filter out duplicates
				const uniqueTriviaQuestions = allTriviaQuestions.filter(q => !existingQuestionTexts.has(q.question));

				// Insert unique questions into the collection
				for (const question of uniqueTriviaQuestions) {
					try {
						await itemsService.createOne(question);
					} catch (error) {
						// Ignore
					}
				}

				res.json({
					success: true,
					message: `Fetched and stored ${uniqueTriviaQuestions.length} unique trivia questions successfully`,
				});
			} catch (error) {
				console.error(error);
				res.status(500).json({
					success: false,
					message: 'Failed to fetch and store trivia questions',
					error: error.message
				});
			}
		});

		router.get('/generate_qr_code', async (req, res) => {
			try {
				const { stage_id } = req.query
				const stagesService = new ItemsService('stages', {
					schema: req.schema,
					accountability: req.accountability,
				});

				let stages = await stagesService.readByQuery({
					filter: {
						id: {
							_eq: stage_id
						}
					},
					fields: ['id','qrcode.*', 'qrcode.qrcode_id.*',]
				})
				let qr_code_data = stages[0].qrcode[0].qrcode_id.value
				QRCode.toBuffer(qr_code_data, { type: 'png' }, function (err, buffer) {
					if (err) {
					  return next(new ServiceUnavailableException('Failed to generate QR code.'));
					}
			
					// Set response headers to return the image
					res.setHeader('Content-Type', 'image/png');
					res.setHeader('Content-Disposition', 'inline; filename="qrcode.png"');
			
					// Send the buffer containing the PNG image
					res.send(buffer);
				  });
			} catch (error) {
				res.status(500).json({
					success: false,
					message: 'Failed to fetch and store trivia questions',
					error: error.message
				});
			}
		});

		function mirrorHorizontally(arr) {
			return arr.map(row => [...row].reverse());
		}

		function mirrorVertically(arr) {
			return [...arr].reverse();
		}

		router.get('/mirror-connectdots', async (req, res) => {
			try {
				const itemsService = new ItemsService('bank_connect_dots', {
					schema: req.schema,
					accountability: req.accountability,
				});

				let existingItems = itemsService.readByQuery({ limit: -1 })

				for (const record of existingItems) {
					const originalArray = record.grid; // Adjust if your field path is different

					// Generate mirrored arrays
					const horizontallyMirrored = mirrorHorizontally(originalArray);
					const verticallyMirrored = mirrorVertically(originalArray);
					const bothMirrored = mirrorVertically(horizontallyMirrored);

					// Insert the original and mirrored arrays back into the collection
					await itemsService.createMany([
						{ grid: horizontallyMirrored, difficulty: record.difficulty },
						{ grid: verticallyMirrored, difficulty: record.difficulty },
						{ grid: bothMirrored, difficulty: record.difficulty }
					]);
				}
				
				res.json({
					success: true,
					message: 'Fetched and stored new recods',
				});
			} catch (error) {
				res.status(500).json({
					success: false,
					message: 'Failed to fetch and store trivia questions',
				});
			}
		});

		router.get('/', (req, res) => res.send('Helpers Enpoints!'));
	},
};
