import { GraphQLEnumType } from './graphql';
import type { EnumValueDefinitionNode } from './graphql';
import type { TypeAsString } from './TypeMapper';
import { SchemaComposer } from './SchemaComposer';
import { ListComposer } from './ListComposer';
import { NonNullComposer } from './NonNullComposer';
import type { ObjMap, ObjMapReadOnly, Extensions, Directive, DirectiveArgs } from './utils/definitions';
import { SchemaPrinterOptions } from './utils/schemaPrinter';
export declare type EnumTypeComposerDefinition = TypeAsString | EnumTypeComposerAsObjectDefinition | GraphQLEnumType;
export declare type EnumTypeComposerAsObjectDefinition = {
    name: string;
    values?: EnumTypeComposerValueConfigMapDefinition;
    description?: string | null;
    extensions?: Extensions;
    directives?: Directive[];
};
export declare type EnumTypeComposerValueConfig = {
    value: any;
    deprecationReason?: string | null;
    description?: string | null;
    astNode?: EnumValueDefinitionNode | null | undefined;
    extensions?: Extensions;
    directives?: Directive[];
    [key: string]: any;
};
export declare type EnumTypeComposerValueConfigDefinition = {
    value?: any;
    deprecationReason?: string | null;
    description?: string | null;
    extensions?: Extensions;
    directives?: Directive[];
    [key: string]: any;
};
export declare type EnumTypeComposerValueConfigMap = ObjMap<EnumTypeComposerValueConfig>;
export declare type EnumTypeComposerValueConfigMapDefinition = ObjMapReadOnly<EnumTypeComposerValueConfigDefinition>;
export declare class EnumTypeComposer<TContext = any> {
    schemaComposer: SchemaComposer<TContext>;
    _gqType: GraphQLEnumType;
    _gqcExtensions?: Extensions;
    _gqcDirectives?: Directive[];
    _gqcIsModified?: boolean;
    _gqcFields: EnumTypeComposerValueConfigMap;
    static create<TCtx = any>(typeDef: EnumTypeComposerDefinition, schemaComposer: SchemaComposer<TCtx>): EnumTypeComposer<TCtx>;
    static createTemp<TCtx = any>(typeDef: EnumTypeComposerDefinition, schemaComposer?: SchemaComposer<TCtx>): EnumTypeComposer<TCtx>;
    constructor(graphqlType: GraphQLEnumType, schemaComposer: SchemaComposer<TContext>);
    hasField(name: string): boolean;
    getFields(): EnumTypeComposerValueConfigMap;
    getField(name: string): EnumTypeComposerValueConfig;
    getFieldNames(): string[];
    setFields(values: EnumTypeComposerValueConfigMapDefinition): this;
    setField(name: string, valueConfig: EnumTypeComposerValueConfigDefinition): this;
    addFields(newValues: EnumTypeComposerValueConfigMapDefinition): this;
    removeField(nameOrArray: string | string[]): this;
    removeOtherFields(fieldNameOrArray: string | string[]): this;
    reorderFields(names: string[]): this;
    extendField(name: string, partialValueConfig: Partial<EnumTypeComposerValueConfigDefinition>): this;
    deprecateFields(fields: {
        [fieldName: string]: string;
    } | string[] | string): this;
    getType(): GraphQLEnumType;
    getTypePlural(): ListComposer<EnumTypeComposer<TContext>>;
    getTypeNonNull(): NonNullComposer<EnumTypeComposer<TContext>>;
    get List(): ListComposer<EnumTypeComposer<TContext>>;
    get NonNull(): NonNullComposer<EnumTypeComposer<TContext>>;
    getTypeName(): string;
    setTypeName(name: string): this;
    getDescription(): string;
    setDescription(description: string): this;
    clone(newTypeNameOrTC: string | EnumTypeComposer<any>): EnumTypeComposer<any>;
    cloneTo(anotherSchemaComposer: SchemaComposer<any>, cloneMap?: Map<any, any>): EnumTypeComposer<any>;
    merge(type: GraphQLEnumType | EnumTypeComposer<any>): this;
    getExtensions(): Extensions;
    setExtensions(extensions: Extensions | undefined): this;
    extendExtensions(extensions: Extensions): this;
    clearExtensions(): this;
    getExtension(extensionName: string): unknown;
    hasExtension(extensionName: string): boolean;
    setExtension(extensionName: string, value: unknown): this;
    removeExtension(extensionName: string): this;
    getFieldExtensions(fieldName: string): Extensions;
    setFieldExtensions(fieldName: string, extensions: Extensions): this;
    extendFieldExtensions(fieldName: string, extensions: Extensions): this;
    clearFieldExtensions(fieldName: string): this;
    getFieldExtension(fieldName: string, extensionName: string): unknown;
    hasFieldExtension(fieldName: string, extensionName: string): boolean;
    setFieldExtension(fieldName: string, extensionName: string, value: unknown): this;
    removeFieldExtension(fieldName: string, extensionName: string): this;
    getDirectives(): Array<Directive>;
    setDirectives(directives: Array<Directive>): this;
    getDirectiveNames(): string[];
    getDirectiveByName(directiveName: string): DirectiveArgs | undefined;
    setDirectiveByName(directiveName: string, args?: DirectiveArgs): this;
    getDirectiveById(idx: number): DirectiveArgs | undefined;
    getFieldDirectives(fieldName: string): Array<Directive>;
    setFieldDirectives(fieldName: string, directives: Array<Directive> | undefined): this;
    getFieldDirectiveNames(fieldName: string): string[];
    getFieldDirectiveByName(fieldName: string, directiveName: string): DirectiveArgs | undefined;
    setFieldDirectiveByName(fieldName: string, directiveName: string, args?: DirectiveArgs): this;
    getFieldDirectiveById(fieldName: string, idx: number): DirectiveArgs | undefined;
    toSDL(opts?: SchemaPrinterOptions): string;
}
//# sourceMappingURL=EnumTypeComposer.d.ts.map