"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SetUnionMany = exports.SetIntersectMany = exports.SetComplement = exports.SetUnion = exports.SetIntersect = exports.SetDistinct = exports.SetIsSubset = exports.SetIncludes = void 0;
/** Returns true if element right is in the set of left */
// prettier-ignore
function SetIncludes(T, S) {
    return T.includes(S);
}
exports.SetIncludes = SetIncludes;
/** Returns true if left is a subset of right */
function SetIsSubset(T, S) {
    return T.every((L) => SetIncludes(S, L));
}
exports.SetIsSubset = SetIsSubset;
/** Returns a distinct set of elements */
function SetDistinct(T) {
    return [...new Set(T)];
}
exports.SetDistinct = SetDistinct;
/** Returns the Intersect of the given sets */
function SetIntersect(T, S) {
    return T.filter((L) => S.includes(L));
}
exports.SetIntersect = SetIntersect;
/** Returns the Union of the given sets */
function SetUnion(T, S) {
    return [...T, ...S];
}
exports.SetUnion = SetUnion;
/** Returns the Complement by omitting elements in T that are in S */
// prettier-ignore
function SetComplement(T, S) {
    return T.filter(L => !S.includes(L));
}
exports.SetComplement = SetComplement;
// prettier-ignore
function SetIntersectManyResolve(T, Init) {
    return T.reduce((Acc, L) => {
        return SetIntersect(Acc, L);
    }, Init);
}
// prettier-ignore
function SetIntersectMany(T) {
    return (T.length === 1
        ? T[0]
        // Use left to initialize the accumulator for resolve
        : T.length > 1
            ? SetIntersectManyResolve(T.slice(1), T[0])
            : []);
}
exports.SetIntersectMany = SetIntersectMany;
/** Returns the Union of multiple sets */
function SetUnionMany(T) {
    const Acc = [];
    for (const L of T)
        Acc.push(...L);
    return Acc;
}
exports.SetUnionMany = SetUnionMany;
