"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Get = exports.Set = exports.Has = exports.Delete = exports.Clear = exports.Entries = void 0;
/** A registry for user defined types */
const map = new Map();
/** Returns the entries in this registry */
function Entries() {
    return new Map(map);
}
exports.Entries = Entries;
/** Clears all user defined types */
function Clear() {
    return map.clear();
}
exports.Clear = Clear;
/** Deletes a registered type */
function Delete(kind) {
    return map.delete(kind);
}
exports.Delete = Delete;
/** Returns true if this registry contains this kind */
function Has(kind) {
    return map.has(kind);
}
exports.Has = Has;
/** Sets a validation function for a user defined type */
function Set(kind, func) {
    map.set(kind, func);
}
exports.Set = Set;
/** Gets a custom validation function for a user defined type */
function Get(kind) {
    return map.get(kind);
}
exports.Get = Get;
