"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = void 0;
const options_js_1 = require("./options.js");
const fs_minipass_1 = require("@isaacs/fs-minipass");
const node_path_1 = __importDefault(require("node:path"));
const list_js_1 = require("./list.js");
const pack_js_1 = require("./pack.js");
function create(opt_, files, cb) {
    if (typeof files === 'function') {
        cb = files;
    }
    if (Array.isArray(opt_)) {
        ;
        (files = opt_), (opt_ = {});
    }
    if (!files || !Array.isArray(files) || !files.length) {
        throw new TypeError('no files or directories specified');
    }
    files = Array.from(files);
    const opt = (0, options_js_1.dealias)(opt_);
    if (opt.sync && typeof cb === 'function') {
        throw new TypeError('callback not supported for sync tar functions');
    }
    if (!opt.file && typeof cb === 'function') {
        throw new TypeError('callback only supported with file option');
    }
    return ((0, options_js_1.isSyncFile)(opt) ? createFileSync(opt, files)
        : (0, options_js_1.isFile)(opt) ? createFile(opt, files, cb)
            : (0, options_js_1.isSync)(opt) ? createSync(opt, files)
                : create_(opt, files));
}
exports.create = create;
const createFileSync = (opt, files) => {
    const p = new pack_js_1.PackSync(opt);
    const stream = new fs_minipass_1.WriteStreamSync(opt.file, {
        mode: opt.mode || 0o666,
    });
    p.pipe(stream);
    addFilesSync(p, files);
};
const createFile = (opt, files, cb) => {
    const p = new pack_js_1.Pack(opt);
    const stream = new fs_minipass_1.WriteStream(opt.file, {
        mode: opt.mode || 0o666,
    });
    p.pipe(stream);
    const promise = new Promise((res, rej) => {
        stream.on('error', rej);
        stream.on('close', res);
        p.on('error', rej);
    });
    addFilesAsync(p, files);
    return cb ? promise.then(cb, cb) : promise;
};
const addFilesSync = (p, files) => {
    files.forEach(file => {
        if (file.charAt(0) === '@') {
            (0, list_js_1.list)({
                file: node_path_1.default.resolve(p.cwd, file.slice(1)),
                sync: true,
                noResume: true,
                onentry: entry => p.add(entry),
            });
        }
        else {
            p.add(file);
        }
    });
    p.end();
};
const addFilesAsync = async (p, files) => {
    for (let i = 0; i < files.length; i++) {
        const file = String(files[i]);
        if (file.charAt(0) === '@') {
            await (0, list_js_1.list)({
                file: node_path_1.default.resolve(String(p.cwd), file.slice(1)),
                noResume: true,
                onentry: entry => {
                    p.add(entry);
                },
            });
        }
        else {
            p.add(file);
        }
    }
    p.end();
};
const createSync = (opt, files) => {
    const p = new pack_js_1.PackSync(opt);
    addFilesSync(p, files);
    return p;
};
const create_ = (opt, files) => {
    const p = new pack_js_1.Pack(opt);
    addFilesAsync(p, files);
    return p;
};
//# sourceMappingURL=create.js.map