import { isDirectusError } from '@directus/errors';
import express from 'express';
import { ErrorCode } from '@directus/errors';
import { respond } from '../middleware/respond.js';
import useCollection from '../middleware/use-collection.js';
import { SettingsService } from '../services/settings.js';
import asyncHandler from '../utils/async-handler.js';
const router = express.Router();
router.use(useCollection('directus_settings'));
router.get('/', asyncHandler(async (req, res, next) => {
    const service = new SettingsService({
        accountability: req.accountability,
        schema: req.schema,
    });
    const records = await service.readSingleton(req.sanitizedQuery);
    res.locals['payload'] = { data: records || null };
    return next();
}), respond);
router.patch('/', asyncHandler(async (req, res, next) => {
    const service = new SettingsService({
        accountability: req.accountability,
        schema: req.schema,
    });
    await service.upsertSingleton(req.body);
    try {
        const record = await service.readSingleton(req.sanitizedQuery);
        res.locals['payload'] = { data: record || null };
    }
    catch (error) {
        if (isDirectusError(error, ErrorCode.Forbidden)) {
            return next();
        }
        throw error;
    }
    return next();
}), respond);
export default router;
