import jwt from 'jsonwebtoken'
import bcrypt from 'bcrypt'
import nodemailer from 'nodemailer'
import AWS from 'aws-sdk'
// https://github.com/directus/directus/blob/main/api/src/services/users.ts
// https://github.com/directus/directus/blob/main/api/src/services/authentication.ts

export default {
  id: 'auth',
  handler: (router, context) => {
    const { services, database, getSchema, env, logger, emitter } = context
    const { ItemsService, UsersService, AuthenticationService } = services

    const JWT_SECRET = env.JWT_SECRET

    function generateLoginToken (user) {
      const payload = {
        id: user.id,
        email: user.email,
        first_name: user.first_name,
        last_name: user.last_name,
        role: user.role
      }

      const accessTokenOptions = { expiresIn: '1h' }
      const refreshTokenOptions = { expiresIn: '7d' }

      const accessToken = jwt.sign(payload, JWT_SECRET, accessTokenOptions)
      const refreshToken = jwt.sign(payload, JWT_SECRET, refreshTokenOptions)

      return {
        accessToken,
        refreshToken,
        payload
      }
    }

    function generateVerificationToken (user) {
      const payload = {
        id: user.id,
        email: user.email
      }

      const options = { expiresIn: '1h' } // Token expires in 1 hour

      return jwt.sign(payload, JWT_SECRET, options)
    }

    const verifyToken = token => {
      try {
        return jwt.verify(token, JWT_SECRET)
      } catch (error) {
        return res.json({ error: error })
        // throw new Error('Invalid token');
      }
    }

    const hashPassword = async password => {
      const salt = await bcrypt.genSalt(10)
      return bcrypt.hash(password, salt)
    }

    const comparePassword = async (password, hash) => {
      return bcrypt.compare(password, hash)
    }

    const transporter = nodemailer.createTransport({
      host: 'mail.in2apps.xyz', // e.g., mail.yourdomain.com
      port: 465, // or 587
      // port: 587, // or 587
      secure: true, // true for port 465, false for other ports
      // secure: false, // true for port 465, false for other ports
      auth: {
        user: 'notifications@in2apps.xyz',
        pass: 'Notifications@2024'
      },
      logger: true, // log information for debugging
      debug: true // include SMTP traffic in the logs
    })
    // Configure AWS SDK
    AWS.config.update({
      region: 'us-east-1', // Replace with your SES region
      accessKeyId: 'AKIAZWBRQW2OAVWMQA5P', // Use environment variables for security
      secretAccessKey: 'RdN6T7JDxtLpFkCPDVdKdoQZnFNHuIz6v3FSZmt4'
    })

    // Create SES service object
    const ses = new AWS.SES({ apiVersion: '2010-12-01' })

    const sendVerificationEmail = async (to, token) => {
      const mailOptions = {
        from: '"The Ultimate Adventure" <notifications@in2apps.xyz>',
        to,
        subject: 'Please verify your email',
        html: `<p>Click the link below to verify your email:</p><p><a href=https://tuacms.in2apps.xyz/auth/verify?token=${token}>Verify Email</a></p>`
      }
      const params = {
        Destination: {
          ToAddresses: [to], // Recipient's email address
        },
        Message: {
          Body: {
            Html: {
              Charset: 'UTF-8',
              Data: `<p>Click the link below to verify your email:</p><p><a href=https://tuacms.in2apps.xyz/auth/verify?token=${token}>Verify Email</a></p>`, // HTML email body
            },
            Text: {
              Charset: 'UTF-8',
              Data: `<p>Click the link below to verify your email:</p><p><a href=https://tuacms.in2apps.xyz/auth/verify?token=${token}>Verify Email</a></p>`.replace(/<[^>]*>/g, ''),
            },
          },
          Subject: {
            Charset: 'UTF-8',
            Data: 'Please verify your email', // Email subject
          },
        },
        Source: 'notifications@in2apps.xyz', // Replace with your verified SES email
      };
    
      try {
        // await transporter.sendMail(mailOptions)
        const result = await ses.sendEmail(params).promise();
        console.log('Verification email sent')
      } catch (error) {
        console.error('Error sending verification email:', error)
      }
    }

    router.post('/register', async (req, res) => {
      const { first_name, last_name, email, password } = req.body
      const usersService = new UsersService({
        schema: req.schema,
        accountability: req.accountability
      })
      // return res.json({ message: 'Registration successful. Please verify your email.' });
      // Check if all required fields are submitted
      if (!first_name || !last_name || !email || !password) {
        return res.status(400).json({ message: 'All fields are required' })
      }

      // Validate that the email is not already in use
      const existingUsers = await usersService.readByQuery({
        filter: { email: { _eq: email } }
      })

      if (existingUsers.length > 0) {
        return res.status(400).json({ message: 'Email is already in use' })
      }

      try {
        // const hashedPassword = await hashPassword(password);
        const user_id = await usersService.createOne({
          first_name,
          last_name,
          email,
          password: password,
          status: 'unverified',
          role: '22e8c021-5759-491a-adc1-5523a6f3a397'
        })
        // user_id here is equal only to the id of the newly created user

        const user = await usersService.readOne(user_id)

        const verificationToken = generateVerificationToken(user)

        await sendVerificationEmail(email, verificationToken)

        res.json({
          message: 'Registration successful. Please verify your email.',
          user: user
        })
      } catch (error) {
        res.status(500).json({ message: error.message })
      }
    })

    router.get('/verify', async (req, res) => {
      const { token } = req.query
      const usersService = new UsersService({
        schema: req.schema,
        accountability: req.accountability
      })

      try {
        const decoded = verifyToken(token)
        await usersService.updateOne(decoded.id, { status: 'active' })
        res.json({ message: 'Email verified successfully.' })
      } catch (error) {
        res.status(400).json({
          message: 'Invalid or expired token.'
        })
      }
    })

    router.post('/plogin', async (req, res) => {
      const { email, password } = req.body
      const usersService = new UsersService({
        schema: req.schema,
        accountability: req.accountability
      })
      const authService = new AuthenticationService({
        accountability: null,
        schema: req.schema,
        knex: req.knex
      })

      try {
        let user = await usersService.getUserByEmail(email)

        const validate = await authService.verifyPassword({
          userID: user.id,
          password: password
        })

        return res.json({ validate: validate })

        if (!user) {
          return res.status(401).json({ message: 'Invalid credentials!' })
        }

        const tokens = generateLoginToken(user)
        res.json({
          validate: validate,
          tokens: 'tokens'
        })
      } catch (error) {
        res.status(500).json({ message: error.message })
      }
    })

    // router.post('/logout', (req, res) => {
    //     // Invalidate the token by sending an empty response (or implementing a token blacklist)
    //     res.json({ message: 'Logout successful' });
    // });

    router.post('/update-password', async (req, res) => {
      const { oldPassword, newPassword } = req.body
      const usersService = new UsersService({
        schema: req.schema,
        accountability: req.accountability
      })

      try {
        const decoded = verifyToken(token)
        const user = await usersService.readOne(decoded.id)

        if (!user || !(await comparePassword(oldPassword, user.password))) {
          return res.status(401).json({ message: 'Invalid current password' })
        }

        const hashedPassword = await hashPassword(newPassword)
        await usersService.updateOne(user.id, { password: hashedPassword })

        res.json({ message: 'Password updated successfully' })
      } catch (error) {
        res.status(500).json({ message: error.message })
      }
    })

    router.post('/update-profile', async (req, res) => {
      const { first_name, last_name } = req.body
      const usersService = new UsersService({
        schema: req.schema,
        accountability: req.accountability
      })

      try {
        const decoded = verifyToken(token)
        await usersService.updateOne(decoded.id, { first_name, last_name })
        res.json({ message: 'Profile updated successfully' })
      } catch (error) {
        res.status(500).json({ message: error.message })
      }
    })

    // router.post('/refresh-token', async (req, res) => {
    //     const { token } = req.body;

    //     try {
    //         const decoded = verifyToken(token);
    //         const newToken = generateToken({ id: decoded.id });

    //         res.json({ token: newToken });
    //     } catch (error) {
    //         res.status(400).json({ message: 'Invalid token' });
    //     }
    // });
  }
}
