import { GraphQLScalarType } from './graphql';
import type { GraphQLScalarTypeConfig, GraphQLScalarSerializer, GraphQLScalarValueParser, GraphQLScalarLiteralParser } from './graphql';
import type { TypeAsString } from './TypeMapper';
import { SchemaComposer } from './SchemaComposer';
import { ListComposer } from './ListComposer';
import { NonNullComposer } from './NonNullComposer';
import type { Extensions, Directive, DirectiveArgs } from './utils/definitions';
import { SchemaPrinterOptions } from './utils/schemaPrinter';
export declare type ScalarTypeComposerDefinition<TInternal, TExternal> = TypeAsString | Readonly<ScalarTypeComposerAsObjectDefinition<TInternal, TExternal>> | Readonly<GraphQLScalarType>;
export declare type ScalarTypeComposerAsObjectDefinition<TInternal, TExternal> = GraphQLScalarTypeConfig<TInternal, TExternal> & {
    extensions?: Extensions;
    directives?: Directive[];
};
export declare class ScalarTypeComposer<TContext = any> {
    schemaComposer: SchemaComposer<TContext>;
    _gqType: GraphQLScalarType;
    _gqcExtensions: Extensions | undefined;
    _gqcDirectives: Directive[] | undefined;
    _gqcIsModified?: boolean;
    _gqcSerialize: GraphQLScalarSerializer<any>;
    _gqcParseValue: GraphQLScalarValueParser<any>;
    _gqcParseLiteral: GraphQLScalarLiteralParser<any>;
    static create<TCtx = any, TInternal = any, TExternal = any>(typeDef: ScalarTypeComposerDefinition<TInternal, TExternal>, schemaComposer: SchemaComposer<TCtx>): ScalarTypeComposer<TCtx>;
    static createTemp<TCtx = any, TInternal = any, TExternal = any>(typeDef: ScalarTypeComposerDefinition<TInternal, TExternal>, schemaComposer?: SchemaComposer<TCtx>): ScalarTypeComposer<TCtx>;
    constructor(graphqlType: GraphQLScalarType, schemaComposer: SchemaComposer<TContext>);
    setSerialize(fn: GraphQLScalarSerializer<any>): this;
    getSerialize(): GraphQLScalarSerializer<any>;
    setParseValue(fn: GraphQLScalarValueParser<any> | undefined): this;
    getParseValue(): GraphQLScalarValueParser<any> | undefined;
    setParseLiteral(fn: GraphQLScalarLiteralParser<any> | undefined): this;
    getParseLiteral(): GraphQLScalarLiteralParser<any> | undefined;
    getType(): GraphQLScalarType;
    getTypePlural(): ListComposer<ScalarTypeComposer<TContext>>;
    getTypeNonNull(): NonNullComposer<ScalarTypeComposer<TContext>>;
    get List(): ListComposer<ScalarTypeComposer<TContext>>;
    get NonNull(): NonNullComposer<ScalarTypeComposer<TContext>>;
    getTypeName(): string;
    setTypeName(name: string): this;
    getDescription(): string;
    setDescription(description: string): this;
    getSpecifiedByUrl(): string | undefined | null;
    setSpecifiedByUrl(url: string | undefined | null): this;
    clone(newTypeNameOrTC: string | ScalarTypeComposer<any>): ScalarTypeComposer<TContext>;
    cloneTo(anotherSchemaComposer: SchemaComposer<any>, cloneMap?: Map<any, any>): ScalarTypeComposer<any>;
    merge(type: GraphQLScalarType | ScalarTypeComposer<any>): ScalarTypeComposer<TContext>;
    getExtensions(): Extensions;
    setExtensions(extensions: Extensions | undefined | null): this;
    extendExtensions(extensions: Extensions): this;
    clearExtensions(): this;
    getExtension(extensionName: string): unknown;
    hasExtension(extensionName: string): boolean;
    setExtension(extensionName: string, value: unknown): this;
    removeExtension(extensionName: string): this;
    getDirectives(): Array<Directive>;
    setDirectives(directives: Array<Directive>): this;
    getDirectiveNames(): string[];
    getDirectiveByName(directiveName: string): DirectiveArgs | undefined;
    setDirectiveByName(directiveName: string, args?: DirectiveArgs): this;
    getDirectiveById(idx: number): DirectiveArgs | undefined;
    toSDL(opts?: SchemaPrinterOptions): string;
}
//# sourceMappingURL=ScalarTypeComposer.d.ts.map