import { withCache } from './with-cache.js';
export const fetchShareInfo = withCache('share-info', _fetchShareInfo);
export async function _fetchShareInfo(shareId, context) {
    const { SharesService } = await import('../../services/shares.js');
    const sharesService = new SharesService(context);
    return (await sharesService.readOne(shareId, {
        fields: ['collection', 'item', 'role', 'user_created.id', 'user_created.role'],
    }));
}
