import { toBoolean } from '@directus/utils';
import { fetchPermittedAstRootFields } from '../../../../database/run-ast/modules/fetch-permitted-ast-root-fields.js';
import { processAst } from '../../process-ast/process-ast.js';
export async function validateItemAccess(options, context) {
    const primaryKeyField = context.schema.collections[options.collection]?.primary;
    if (!primaryKeyField) {
        throw new Error(`Cannot find primary key for collection "${options.collection}"`);
    }
    // When we're looking up access to specific items, we have to read them from the database to
    // make sure you are allowed to access them.
    const ast = {
        type: 'root',
        name: options.collection,
        query: { limit: options.primaryKeys.length },
        // Act as if every field was a "normal" field
        children: options.fields?.map((field) => ({ type: 'field', name: field, fieldKey: field, whenCase: [] })) ?? [],
        cases: [],
    };
    await processAst({ ast, ...options }, context);
    // Inject the filter after the permissions have been processed, as to not require access to the primary key
    ast.query.filter = {
        [primaryKeyField]: {
            _in: options.primaryKeys,
        },
    };
    const items = await fetchPermittedAstRootFields(ast, {
        schema: context.schema,
        accountability: options.accountability,
        knex: context.knex,
        action: options.action,
    });
    if (items && items.length === options.primaryKeys.length) {
        const { fields } = options;
        if (fields) {
            return items.every((item) => fields.every((field) => toBoolean(item[field])));
        }
        return true;
    }
    return false;
}
