import type { KNEX_TYPES } from '@directus/constants';
import type { Field, Relation, Type } from '@directus/types';
import type { Knex } from 'knex';
import type { Options, SortRecord, Sql } from '../types.js';
import { SchemaHelper } from '../types.js';
export declare class SchemaHelperOracle extends SchemaHelper {
    changeToType(table: string, column: string, type: (typeof KNEX_TYPES)[number], options?: Options): Promise<void>;
    castA2oPrimaryKey(): string;
    preRelationChange(relation: Partial<Relation>): void;
    processFieldType(field: Field): Type;
    getDatabaseSize(): Promise<number | null>;
    prepQueryParams(queryParams: Sql): Sql;
    prepBindings(bindings: Knex.Value[]): any;
    addInnerSortFieldsToGroupBy(groupByFields: (string | Knex.Raw)[], sortRecords: SortRecord[], _hasRelationalSort: boolean): void;
}
