@extends('user_type.auth', ['parentFolder' => '', 'childFolder' => 'none'])

@section('content')
<main class="main-content mt-1 border-radius-lg">
    
    <div class="container my-3 py-3 d-flex flex-column">
        @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
        <div class="row mb-5 justify-content-center align-items-center">
            <div class="col-lg-9 col-12 mx-auto">
                <!-- Card Profile -->
                <div class="row">
                    <div class="col-4"></div>
                    <div class="col-4">
                        <div class="card card-body text-center">
                            <div class="row col-lg-12">
                                <div class="col-sm-12">
                                    <div class="avatar avatar-xxl">
                                        <div>
                                           
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <!-- <div class="h-100"> -->
                                        <h5 class="mb-1 font-weight-bolder">
                                            {{$data->name}}
                                        </h5>
                                        <p class="mb-0 font-weight-bold text-sm">
                                            Upgrade Account
                                        </p>
                                    <!-- </div> -->
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="col-4"></div>
                </div>
                
                <div class="card mt-4" id="basic-info">
                    <div class="card-header">
                        <h5>Current Subscription Status</h5>
                    </div>
                    <div class="card-body pt-0">
                        <div class="row">
                            <div class="col-sm-4 col-lg-4">
                                <label class="form-label mt-4">Subscription Plan</label>
                                <div class="input-group">
                                    <input class="form-control" type="text"  value="{{$current[0]->title}} | {{($data->subscription == 1) ? 'FREE PLAN ' : 'PAID PLAN'}}" readonly>
                                </div>
                            </div>

                            <div class="col-sm-4 col-lg-4">
                                <label class="form-label mt-4">Subscription Purchased AT</label>
                                <div class="input-group">
                                    <input class="form-control" type="text"  value="{{($data->subscription == 1) ? 'FREE PLAN ' : $data->purchased_at}}" readonly>
                                </div>
                            </div>
                            
                            <div class="col-sm-4 col-lg-4">
                                <label class="form-label mt-4">Subscription Expired AT</label>
                                <div class="input-group">
                                    <input class="form-control" type="text" value="{{($data->subscription == 1) ? 'NEVER' : $data->expired_at}}" readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Basic Info -->
                <div class="card mt-4" id="basic-info">
                    <div class="card-header">
                        <h5>  Upgrade Account</h5>
                    </div>
                    <div class="card-body pt-0">
                        <form action="/users/subscription/upgrade" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="id" value="{{$data->cust_id}}">
                            
                            <div class="row">
                                
                                <div class="col-sm-12">
                                    <label class="form-label mt-1">Select Subscription Plan</label>
                                    <div class="input-group">
                                        <select name="subscription" class="form-control">
                                            @foreach($sub as $item)
                                            <option value="{{$item->id}}"> {{$item->currency}} {{$item->amount}} |  {{$item->title}} | {{$item->valid_for}} Month</option>
                                           @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="">
                                <button type="submit" class="btn bg-gradient-dark btn-sm float-end mt-6 mb-0">Upgrade</button>
                            </div>
                    </div>
                </div>

                
            </div>
        </div>
    </div>
</main>
@endsection
@push('js')
<script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
<script>
    // $("#file-input").change(function(){
    //     readURL(this);
    // });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        $("#alert-success").delay(3000).slideUp(300);
        $("#conv").hide();

    });

    if (document.getElementById('choices-tag')) {
        var tag = document.getElementById('choices-tag');
        const example = new Choices(tag);
    }

    $('#choices-tag').change(function() {
        var optVal = $("#choices-tag option:selected").val();
        if (optVal == 1) {
            $('#conv').show();
        } else {
            $('#conv').hide();
        }
    });
</script>
@endpush