@extends('user_type.auth', ['parentFolder' => 'video', 'childFolder' => ''])

@section('content')
<div class="row">
    <div class="col-lg-9 col-12 mx-auto">
        @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
        
        <div class="card card-body mt-4">
            <h6 class="mb-0">Add Native </h6>
            <p class="text-sm mb-0">Fill Data</p>
            <form action="/ads/store" method="POST"  enctype="multipart/form-data">
            @csrf
            
             <input type="hidden" name="ad_type" value="native" />
             
            <hr class="horizontal dark my-3">
            <label for="projectName" class="form-label">Ads Title</label>
            <input type="text" class="form-control" name="title" value="{{old('title')}}" placeholder="Ads Video" required>
            
            
            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Ad Icon [ 100 * 100 ]</label>
            <input type="file" class="form-control" name="icon" placeholder="https://" required>
            @error('icon')
                <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
            @enderror


            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Ads Thumbnail [Height 250 * Width 400 ]</label>
            <input type="file" class="form-control" name="image" required>
            @error('image')
                <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
            @enderror
            
            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Ads Button Name </label>
            <input type="text" class="form-control" name="btn_name" value="{{old('btn_name')}}" placeholder="Visit / Install / Get">
            @error('btn_name')
                <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
            @enderror
            
            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Ads Button Link </label>
            <input type="text" class="form-control" name="url" value="{{old('url')}}" placeholder="http://">
            @error('url')
                <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
            @enderror

        
            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Ads Description Max 2-3 Line</label>
            <input type="text" class="form-control" name="description" value="{{old('description')}}" placeholder="the app is for earn gift card">
            @error('description')
                <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
            @enderror

            <div class="d-flex justify-content-end mt-4">
                <a href="{{ url('/ads/native') }}" type="button" name="button" class="btn btn-light m-0">BACK TO LIST</a>
                <button type="submit" name="button" class="btn bg-gradient-info m-0 ms-2">Add Ad</button>
            </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('js')
<script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
<script>
    if (document.getElementById('choices-tag')) {
      var tag = document.getElementById('choices-tag');
      const example = new Choices(tag);
    }
</script>
@endpush