@extends('user_type.auth', ['parentFolder' => '', 'childFolder' => 'none'])

@section('content')
<main class="main-content mt-1 border-radius-lg">
    <div class="container my-3 py-3 d-flex flex-column">
        @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
        <div class="row mb-5 justify-content-center align-items-center">
            <div class="col-lg-9 col-12 mx-auto">
                <!-- Card Profile -->
                <div class="row">
                    <div class="col-4"></div>
                    <div class="col-4">
                        <div class="card card-body text-center">
                            <div class="row col-lg-12">
                                <div class="col-sm-12">
                                    <div class="avatar avatar-xxl">
                                        <div>
                                            <span class="h-12 w-12 rounded-full overflow-hidden bg-gray-100 ">
                                                <img src="{{ url('images/'.$data[0]->image)}}" class="avatar-xl shadow align-items-center" id="imgDisplay" alt="Profile Photo">
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <!-- <div class="h-100"> -->
                                        <h5 class="mb-1 font-weight-bolder">
                                            {{$data[0]->title}}
                                        </h5>
                                        <p class="mb-0 font-weight-bold text-sm">
                                           Payment Gateway
                                        </p>
                                    <!-- </div> -->
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="col-4"></div>
                </div>
                <!-- Card Basic Info -->
                <div class="card mt-4" id="basic-info">
                    <div class="card-header">
                        <h5>Offerwall Configuration</h5>
                    </div>
                    <div class="card-body pt-0">
                        <form action="/setting/update/gateway" method="POST" enctype="multipart/form-data">
                            @csrf

                            <input type="hidden" name="id" value="{{$data[0]->id}}">
                            <input type="hidden" name="oldicon" value="{{$data[0]->image}}">
                            
                            <div class="row">
                                
                                <div class="col-sm-12">
                                    <label class="form-label mt-4">Gateway Name</label>
                                    <div class="input-group">
                                        <input class="form-control" type="text" name="title" value="{{$data[0]->title}}" required>
                                    </div>
                                </div>
                                
                                <div class="col-sm-12">
                                    <label class="form-label mt-4">Gateway Order</label>
                                    <div class="input-group">
                                        <input class="form-control" type="number" name="row_order" value="{{$data[0]->row_order}}" placeholder="1,2,3" required>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <label class="form-label mt-4">Gateway Icon</label>
                                    <div class="input-group">
                                        <input class="form-control" name="icon" type="file">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                @foreach((array)$network as $item)
                                <label class="form-label mt-4">{{ $item['name']}}</label>
                                <div class="input-group">
                                    <input  class="form-control" type="text" name="keyval[]" placeholder="{{ $item['name']}}" value="{{ $item['value']}}" required>
                                </div>

                                @endforeach
                            </div>
                            
                             <div class="col-sm-12">
                                 <label class="form-label mt-4">Payment Gateway mode</label>
                                    <div class="input-group">
                                        <select name="test_mode" class="form-control">
                                            <option value="true" {{($data[0]->test_mode =='true') ? 'selected' : '' }}>Test Mode</option>
                                            <option value="false" {{($data[0]->test_mode =='false') ? 'selected' : '' }}>Release Mode</option>
                                        </select>
                                    </div>
                                </div>
                                
                                 <div class="col-sm-12">
                                    <label class="form-label mt-4">Gateway Available in Country ( all for all country)</label>
                                    <div class="input-group">
                                        <input class="form-control" name="country" value="{{$data[0]->country}}" placeholder="all" required>
                                    </div>
                                </div>

                            <div class="">
                                <button type="submit" class="btn bg-gradient-dark btn-sm float-end mt-6 mb-0">Save changes</button>
                            </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</main>
@endsection
@push('js')
<script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
<script>
    // $("#file-input").change(function(){
    //     readURL(this);
    // });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        $("#alert-success").delay(3000).slideUp(300);
        $("#conv").hide();

    });

    if (document.getElementById('choices-tag')) {
        var tag = document.getElementById('choices-tag');
        const example = new Choices(tag);
    }

    $('#choices-tag').change(function() {
        var optVal = $("#choices-tag option:selected").val();
        if (optVal == 1) {
            $('#conv').show();
        } else {
            $('#conv').hide();
        }
    });
</script>
@endpush