@extends('user_type.auth', ['parentFolder' => 'offer', 'childFolder' => ''])

@section('content')
<div class="row">
    <div class="col-lg-9 col-12 mx-auto">
        
        @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
        <div class="card card-body mt-4">
            <h6 class="mb-0">Add Offer Toro</h6>
            <p class="text-sm mb-0">Fill Data</p>
            <hr class="horizontal dark my-3">

            <form action="/offers/create" method="POST">
            @csrf    
            <input type="hidden" name="id" value="{{$data->id}}">
            <input type="hidden" name="offer_type" value="offer_toro">

            <label for="projectName" class="form-label">App Name</label>
            <input type="text" class="form-control" name="app_name" value="{{$data->offer_name}}" id="projectName" placeholder="My App" required>

            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">App Icon URL</label>
            <input type="text" class="form-control" name="image" value="{{$data->image_url}}" id="projectName" placeholder="Http://" required>

            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">App URL</label>
            <input type="text" class="form-control" name="appurl" value="{{$data->offer_url}}"  placeholder="Http://" required>

            <div class="row">
                <div class="col-sm-12 col-lg-4">
                    <hr class="horizontal dark my-2">
                    <label for="projectName" class="form-label">Paramater for <small class="text-info text-sm">USER ID</small></label>
                    <input type="text" class="form-control" name="p_userid" placeholder="subid=" value="USER_ID=" required readonly>
                </div>
                
                <div class="col-sm-12 col-lg-4">
                    <hr class="horizontal dark my-2">
                    <label for="projectName" class="form-label">Postback Parameter <small class="text-info text-sm">App ID </small></label>
                    <select class="form-control" name="appID" required readonly>
                        <option value="0" >subid2={subid2}</option>
                        <option value="1">offerid={offerid}</option>
                        <option value="2">appid={appid}</option>
                        <option value="3" selected>offer_id={offer_id}</option>
                    </select>
                </div>
                
                <div class="col-sm-12 col-lg-4">
                    <hr class="horizontal dark my-2">
                    <label for="projectName" class="form-label">Postback <small class="text-info text-sm">Response Code</small></label>
                    <input type="text" class="form-control" name="response_code" placeholder="201" value="201" required>
                </div>
            
            </div>

            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Payout ( You will earn Per Successfull Complete)</label>
            <input type="text" class="form-control" name="payout" value="{{$data->payout}}" placeholder="5" required readonly>
            
            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Install Coin (User Get After Complete task)</label>
            <input type="number" class="form-control" name="points" value="{{$data->amount}}" placeholder="5" required>

            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Count of Users, who will Install Apps (Note: 0 = unlimited)</label>
            <input type="number" class="form-control" name="task_limit" value="0" placeholder="0">

            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Available in Country (Note: all = Available in Country)</label>
            <input type="text" class="form-control" name="country" value="{{$data->countries}}" placeholder="all or IN,CS" required>
            
            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Offer Valid Till</label>
            <input type="date" class="form-control" name="expired_at"  placeholder="Pick Expire Date" required>

            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">App Instruction</label>
            <textarea class="ckeditor form-control" name="details" required>{{$data->offer_desc}}</textarea>


            <div class="d-flex justify-content-end mt-4">
                <a href="{{ url('/offers/offertoro_offers') }}" type="button" name="button" class="btn btn-light m-0">BACK TO LIST</a>
                <button type="submit" name="button" class="btn bg-gradient-info m-0 ms-2">Add Offer</button>
            </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('js')
<script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script>


    if (document.getElementById('choices-tag')) {
      var tag = document.getElementById('choices-tag');
      const example = new Choices(tag);
    }

    quill.on('text-change', function(delta, oldDelta, source) {
        document.getElementById("quill_html").value = quill.root.innerHTML;
    });
</script>
@endpush