@extends('user_type.auth', ['parentFolder' => '', 'childFolder' => ''])

@section('content')
<div class="row">
    <div class="col-lg-9 col-12 mx-auto">
        @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
        
        
        <div class="card card-body mt-4">
            <h6 class="mb-0">Update Contest</h6>
            <p class="text-sm mb-0">Fill Data</p>

            <form action="/contest/update" method="POST"  enctype="multipart/form-data">
            @csrf
            <input name="id" type="hidden" value="{{$data->id}}">
            <input name="oldicon" type="hidden" value="{{$data->image}}">
            
            <div class="form-group">
                <label for="recipient-name" class="form-label">Select Contest Type</label>
                <select name="type" class="form-control" required>
                    <option value="refer" {{($data->type == 'refer') ? 'selected' : '' }}</option>Refer Task ( User need to invite x user and get bonus )</option>
                    <option value="level" {{($data->type == 'level') ? 'selected' : '' }}>Reach Level ( User need to compelte x level and to get bonus )</option>
                </select>
            </div>
            
            <div class="row">
                <div class="col-3">
                    <div class="form-group">
                        <label for="recipient-name" class="form-label">Title English</label>
                        <input type="text" class="form-control" name="title_en" value="{{$data->title_en}}" placeholder="Invite 5 Friend /Reach at level 5" required>
                    </div>
                </div>
                
                <div class="col-3">
                    <div class="form-group">
                        <label for="recipient-name" class="form-label">Title Arabic</label>
                        <input type="text" class="form-control" name="title_ar" value="{{$data->title_ar}}" placeholder="Invite 5 Friend /Reach at level 5" required>
                    </div>
                </div>
                
                <div class="col-3">
                    <div class="form-group">
                        <label for="recipient-name" class="form-label">Title Indonesian</label>
                        <input type="text" class="form-control" name="title_in" value="{{$data->title_in}}"  placeholder="Invite 5 Friend /Reach at level 5" required>
                    </div>
                </div>
                
                <div class="col-3">
                    <div class="form-group">
                        <label for="recipient-name" class="form-label">Title French</label>
                        <input type="text" class="form-control" name="title_fr" value="{{$data->title_fr}}" placeholder="Invite 5 Friend /Reach at level 5" required>
                    </div>
                </div>
                
            </div>
            
            <div class="row">
                <div class="col-3">
                    <div class="form-group">
                        <label for="recipient-name" class="form-label">Title German</label>
                        <input type="text" class="form-control" name="title_de" value="{{$data->title_de}}" placeholder="Invite 5 Friend /Reach at level 5" required>
                    </div>
                </div>
                
                <div class="col-3">
                    <div class="form-group">
                        <label for="recipient-name" class="form-label">Title Spanish</label>
                        <input type="text" class="form-control" name="title_es" value="{{$data->title_es}}" placeholder="Invite 5 Friend /Reach at level 5" required>
                    </div>
                </div>
                
                <div class="col-3">
                    <div class="form-group">
                        <label for="recipient-name" class="form-label">Title Vietnamese</label>
                        <input type="text" class="form-control" name="title_vi"  value="{{$data->title_vi}}" placeholder="Invite 5 Friend /Reach at level 5" required>
                    </div>
                </div>
                
                <div class="col-3">
                    <div class="form-group">
                        <label for="recipient-name" class="form-label">Title Italian</label>
                        <input type="text" class="form-control" name="title_it"  value="{{$data->title_it}}" placeholder="Invite 5 Friend /Reach at level 5" required>
                    </div>
                </div>
                
            </div>
            
            <div class="row">
                <div class="col-3">
                    <div class="form-group">
                        <label for="recipient-name" class="form-label">Title Bangla</label>
                        <input type="text" class="form-control" name="title_bn" value="{{$data->title_bn}}" placeholder="Invite 5 Friend /Reach at level 5" required>
                    </div>
                </div>
               
                
            </div>

            <div class="form-group">
                <label for="recipient-name" class="form-label">Icon </label>
                <input type="file" class="form-control" name="icon" >
            </div>

            <div class="form-group">
                <label for="recipient-name" class="form-label">Refer Required</label>
                <input type="number" class="form-control" name="task_require"  value="{{$data->task_require}}" placeholder="5" required>
            </div>

            <div id="date" class="row">
                <div class="form-group col-6">
                    <label for="recipient-name" class="form-label">Start From</label>
                    <input type="date" class="form-control" name="start_from" id="start_from"  value="{{$data->start_from}}"  placeholder="Pick Start Date">
                </div>
                
                 <div class="form-group col-6">
                    <label for="recipient-name" class="form-label">Valid Till</label>
                    <input type="date" class="form-control" name="expired_at" id="expired_at"   value="{{$data->expired_at}}"  placeholder="Pick End Date">
                </div>
            </div>

            <div class="form-group">
                <label for="recipient-name" class="form-label">After Complete Contest user get Coin</label>
                <input type="number" class="form-control" name="coin" placeholder="10"  value="{{$data->coin}}"  required>
            </div>
                    
            <div class="d-flex justify-content-end mt-4">
                <a href="{{ url('/contest') }}" type="button" name="button" class="btn btn-light m-0">BACK TO LIST</a>
                <button type="submit" name="button" class="btn bg-gradient-info m-0 ms-2">Update Contest</button>
            </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('js')
<script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script>
     $(document).ready(function () {
        $("#alert-success").delay(3000).slideUp(300);

    });

    if (document.getElementById('choices-tag')) {
        var tag = document.getElementById('choices-tag');
        const example = new Choices(tag);
    }

    
    
</script>
@endpush