<?php

namespace App\Http\Controllers;

use App\Models\Users;
use App\Models\MOfferwall;
use App\Models\_VideoWall;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use File,Image;
use Illuminate\Support\Facades\Validator;

use function Ramsey\Uuid\v1;

class Offerwall extends Controller
{
    
    public function create(){
        return view('offer.add');
    }
    
    public function index(){
        if(isset(request()->type) && request()->type!='All'){
            $data = MOfferwall::where(['type'=>'sdk','offer_type'=>request()->type])->paginate();
        }else{
             $data = MOfferwall::where(['type'=>'sdk'])->paginate();
        }
        return view('offerwall.sdk', compact('data'));
    }
    
    public function editsdk(MOfferwall $id){
        $network = array();
        foreach (json_decode($id->data) as $item) {
            array_push($network, ['name' => $item->key, 'value' => $item->value]);
        }
        $p=DB::table('postback')->where('offerwall_id',$id->id)->get();
        return view('offerwall/edit-sdk',['data'=>$id,'network'=>$network,'pb'=>$p]);
    }
    
    public function updateSdk(Request $req){
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        if($req->icon){
            $image = $req->icon;
            $filenameWithExt = $image->getClientOriginalName();
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $filename = preg_replace("/[^A-Za-z0-9 ]/", '', $filename);
            $filename = preg_replace("/\s+/", '-', $filename);
            $extension = $image->getClientOriginalExtension();
            $fileNameToStore = $filename.'_'.time().'.'.$extension;
            $image_resize = Image::make($image->getRealPath());
            $image_resize->resize(200,150);  
            $save= $image_resize->save('images/'.$fileNameToStore);
            $imagePath = public_path('images/'.$req->oldimage);
            if(File::exists($imagePath)){
               unlink($imagePath);
            }
            $icon=$fileNameToStore;
        }else{
            $icon=$req->oldimage;
        }
        
        
        $sdk=DB::table('offerwall')->where('id',$req->id)->get();
        $ofr = json_decode($sdk[0]->data);
        $data = array();
        $val = $req->keyval;
        $cnt =  count($val);
        for ($i = 0; $i < $cnt; $i++) {
            array_push($data, ['key' => $ofr[$i]->key, 'slug' => $ofr[$i]->slug, 'value' => $val[$i]]);
        }
        
        $u=DB::table('offerwall')->where('id',$req->id)->update([
            'title'=>$req->title,
            'offer_slug'=>$req->offer_slug,
            'test_mode'=>$req->test_mode,
            'thumb'=>$icon,
            'description'=>$req->description,
            'data'=>$data,
            'offer_type'=>$req->offer_type,
            'u_tag'=>$req->u_tag,
            // 'c_status'=>$req->tag,
            ]);
        
            if($req->userid!=""){ $puser=''.$req->userid; }else{$puser='';}
            if($req->appid!=""){ $pappid='&'.$req->appid; }else{$pappid='';}
            if($req->amount!=""){ $pamount='&'.$req->amount; }else{$pamount='';}
            if($req->p_offername!=""){ $p_offername='&'.$req->p_offername; }else{$p_offername='';}
            if($req->offerid!=""){ $pofferid='&'.$req->offerid; }else{$pofferid='';}
            if($req->ip!=""){ $pip='&'.$req->ip; }else{$pip='';}

          $domainURL = '&';

         $pb=DB::table('postback')->where('offerwall_id',$req->id)->update([
                'postback_url'=>$domainURL.$puser.$pamount.$pip.$pofferid.$p_offername,
                'offerwall_name'=>$req->title,
                'p_userid'=>$req->userid,
                'response_code'=>$req->response_code,
                'p_payout'=>$req->amount,
                'p_campaing_id'=>$req->offerid,
                'p_ip'=>$req->ip,
                'p_offername'=>$req->p_offername
                ]);
            
        return redirect('/offerwall/sdk')->with('success','Update SuccessFully!');
        
    }


    //web
    public function indexWeb(){
        if(isset(request()->type) && request()->type!='All'){
            $data = MOfferwall::where(['type'=>'web','offer_type'=>request()->type])->paginate();
        }else{
             $data = MOfferwall::where(['type'=>'web'])->paginate();
        }
        return view('offerwall.web', compact('data'));
    }
    
    public function editWeb(MOfferwall $id){
        
         return view('offerwall.edit-web',[
          'data'=>$id]);

    }
    
    public function createWeb(Request $req){
        
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        
        $validator = Validator::make($req->all(), [
            'title' => 'required',
            'icon' => 'required|mimes:jpeg,png,jpg',
            'description' => 'required',
            'offerwall_slug' => 'required',
            'offerwall_url' => 'required',
            'offer_type' => 'required',
            'u_tag' => 'required',
            'uid_type' => 'required',
            'p_userid' => 'required',
            'p_payout' => 'required',
            'p_campaing_id' => 'required',
            'p_offername' => 'required',
            'response_code' => 'required',
            'offer_complete_title' => 'required',
            'item_order' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect('/offerwall/create')
                ->withErrors($validator)
                ->withInput();
        }
        
        if ($req->p_userid != "") { $puser = '' . $this->clean($req->p_userid).'='.$req->p_userid; } else { $puser = '';}
        if ($req->p_payout != "") {$pamount = '&' . $this->clean($req->p_payout).'='.$req->p_payout;} else { $pamount = '';}
        if ($req->p_offername != "") {$p_offername = '&' . $this->clean($req->p_offername).'='.$req->p_offername;} else { $p_offername = '';}
        if ($req->p_campaing_id != "") {$pofferid = '&' . $this->clean($req->p_campaing_id).'='.$req->p_campaing_id; } else { $pofferid = '';}
        if ($req->p_ip != "") {$pip = '&' . $this->clean($req->p_ip).'='.$req->p_ip;} else { $pip = '';}
        $domainURL = '&';

        $postback_url = $domainURL . $puser . $pamount . $pip . $pofferid . $p_offername;
        
        $image = $req->icon;
        $filenameWithExt = $image->getClientOriginalName();
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        $filename = preg_replace("/[^A-Za-z0-9 ]/", '', $filename);
        $filename = preg_replace("/\s+/", '-', $filename);
        $extension = $image->getClientOriginalExtension();
        $fileNameToStore = $filename.'_'.time().'.'.$extension;
        $image_resize = Image::make($image->getRealPath());
        $save= $image_resize->save('images/'.$fileNameToStore);
        
        $offer= new MOfferwall;
        $offer->title = $req->title;
        $offer->description = $req->description;
        $offer->offerwall_slug = str_replace(' ', '_', strtolower($req->offerwall_slug));
        $offer->thumb = $fileNameToStore;
        $offer->offerwall_url = $req->offerwall_url;
        $offer->offer_type = $req->offer_type;
        $offer->home = $req->home;
        $offer->u_tag = $req->u_tag;
        $offer->advid_tag = $req->advid_tag;
        $offer->card_color = $req->card_color;
        $offer->text_color = $req->text_color;
        $offer->browser_type = $req->browser_type;
        $offer->uid_type = $req->uid_type;
        $offer->p_userid = $req->p_userid;
        $offer->p_payout = $req->p_payout;
        $offer->p_campaing_id = $req->p_campaing_id;
        $offer->p_ip = $req->p_ip;
        $offer->p_offername = $req->p_offername;
        $offer->p_admin_payout = $req->p_admin_payout;
        $offer->response_code = $req->response_code;
        $offer->offer_complete_title = $req->offer_complete_title;
        $offer->postback_url = $postback_url;
        $offer->item_order = $req->item_order;
        $offer->save();
            
        return redirect('/offerwall/web')->with('success','Create SuccessFully!');
        
    }
    
    public function updateWeb(Request $req){
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        
        if ($req->p_userid != "") { $puser = '' . $this->clean($req->p_userid).'='.$req->p_userid; } else { $puser = '';}
            if ($req->p_payout != "") {$pamount = '&' . $this->clean($req->p_payout).'='.$req->p_payout;} else { $pamount = '';}
            if ($req->p_offername != "") {$p_offername = '&' . $this->clean($req->p_offername).'='.$req->p_offername;} else { $p_offername = '';}
            if ($req->p_campaing_id != "") {$pofferid = '&' . $this->clean($req->p_campaing_id).'='.$req->p_campaing_id; } else { $pofferid = '';}
            if ($req->p_ip != "") {$pip = '&' . $this->clean($req->p_ip).'='.$req->p_ip;} else { $pip = '';}
            if ($req->p_admin_payout != "") {$p_admin_payout = '&' . $this->clean($req->p_admin_payout).'='.$req->p_admin_payout;} else { $p_admin_payout = '';}
            $domainURL = '&';

            $postback_url = $domainURL . $puser . $pamount . $pip . $pofferid.$p_admin_payout . $p_offername;

        $offer= MOfferwall::find($req->id);

        if($req->icon){

            $validate = Validator::make($req->all(), [
                'icon' => "required|mimes:jpeg,png,jpg",
            ],[
                'icon'=>'Please Select valid Image Supported Jpeg/Png'
                ]);
            if ($validate->fails()) {
                return redirect('/offerwall/web')->with('error', $validate->errors()->first());
            }

            
            $image = $req->icon;
            $filenameWithExt = $image->getClientOriginalName();
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $filename = preg_replace("/[^A-Za-z0-9 ]/", '', $filename);
            $filename = preg_replace("/\s+/", '-', $filename);
            $extension = $image->getClientOriginalExtension();
            $fileNameToStore = $filename.'_'.time().'.'.$extension;
            $image_resize = Image::make($image->getRealPath());
            $save= $image_resize->save('images/'.$fileNameToStore);
            $imagePath = public_path('images/'.$req->oldimage);
            
            try {

             if(File::exists($imagePath)){
               unlink($imagePath);
            }
            
            } catch (\Exception $e) {}
           
            $offer->thumb=$fileNameToStore;
        }
        
        $offer->title = $req->title;
        $offer->description = $req->description;
        $offer->offerwall_slug = str_replace(' ', '_', strtolower($req->offerwall_slug));
        $offer->offerwall_url = $req->offerwall_url;
        $offer->offer_type = $req->offer_type;
        $offer->home = $req->home;
        $offer->u_tag = $req->u_tag;
        $offer->advid_tag = $req->advid_tag;
        $offer->card_color = $req->card_color;
        $offer->text_color = $req->text_color;
        $offer->browser_type = $req->browser_type;
        $offer->uid_type = $req->uid_type;
        $offer->p_userid = $req->p_userid;
        $offer->p_payout = $req->p_payout;
        $offer->p_campaing_id = $req->p_campaing_id;
        $offer->p_ip = $req->p_ip;
        $offer->p_offername = $req->p_offername;
        $offer->p_admin_payout = $req->p_admin_payout;
        $offer->response_code = $req->response_code;
        $offer->offer_complete_title = $req->offer_complete_title;
        $offer->postback_url = $postback_url;
        $offer->item_order = $req->item_order;
        $offer->save();
        
        return redirect('/offerwall/web')->with('success','Update SuccessFully!');
    }
    
    
    function clean($string) {
       $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
       return preg_replace('/[^\w\-_]/', '', $string); // Removes special chars.
    }

    

    //videowall
    public function indexVideoWall(){
        $data = _VideoWall::paginate();
        return view('offerwall.videowall', compact('data'));
    }
     
     
    public function editVideoWall(_VideoWall $id){
        $network = array();
        foreach (json_decode($id->adID) as $item) {
            array_push($network, ['name' => $item->key, 'value' => $item->value]);
        }
        return view('offerwall/edit-videowall',['data'=>$id,'network'=>$network]);
    }
    
    public function updateVideoWall(Request $req){
        
        if(auth()->user()->role_edit=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        if($req->icon){
            $image = $req->icon;
            $filenameWithExt = $image->getClientOriginalName();
            $extension = $image->getClientOriginalExtension();
            $fileNameToStore = uniqid().'_'.time().'.'.$extension;
            $image_resize = Image::make($image->getRealPath());
            $image_resize->resize(150,150);  
            $save= $image_resize->save('images/'.$fileNameToStore);
            
            if($req->oldimage!=null){
                $imagePath = public_path('images/'.$req->oldimage);
                if(File::exists($imagePath)){
                   unlink($imagePath);
                }
            }
            $icon=$fileNameToStore;
        }else{
            $icon=$req->oldimage;
        }
        
        $video=_VideoWall::find($req->id);
        $ofr = json_decode($video->adID);
        $data = array();
        $val = $req->keyval;
        $cnt =  count($val);
        for ($i = 0; $i < $cnt; $i++) {
            array_push($data, ['key' => $ofr[$i]->key, 'slug' => $ofr[$i]->slug, 'value' => $val[$i]]);
        }
        
        $video->adID=$data;
        $video->title=$req->title;
        $video->subtitle=$req->subtitle;
        $video->coin=$req->coin;
        $video->row_order=$req->row_order;
        $video->image=$icon;
        $video->save();
        
         return redirect('/offerwall/videowall')->with('success','Videowall Update SuccessFully!');    
    }

    public function destroyOfferwall($id){
        
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }
        MOfferwall::where('id',$id)->delete();
        return 1;
    }

    public function actionVideoWall(Request $req){
        if(auth()->user()->role_edit=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

         if($req->status=="enable"){
            $update =_VideoWall::whereIn('id',explode(",",$req->id))->update(['status'=>0]); 
            if($update){
                return 1;
            }else{
                return "not updated";
            }
        }
        else if($req->status=="disable"){
            $update =_VideoWall::whereIn('id',explode(",",$req->id))->update(['status'=>1]); 
            if($update){
                return 1;
            }else{
                return "not updated";
            }
        }
    }
    
    public function action(Request $req){
        if(auth()->user()->role_edit=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

         if($req->status=="enable"){
            $update =MOfferwall::whereIn('id',explode(",",$req->id))->update(['status'=>0]); 
            if($update){
                return 1;
            }else{
                return "not updated";
            }
        }
        else if($req->status=="disable"){
            $update =MOfferwall::whereIn('id',explode(",",$req->id))->update(['status'=>1]); 
            if($update){
                return 1;
            }else{
                return "not updated";
            }
        }
    }
        
}
