<?php

namespace App\Http\Controllers;

use App\Models\Users;
use App\Models\AppOffer;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;

class Offers extends Controller
{
    public function index()
    {
        $sign=DB::table('admin_key')->where('id','1')->select('offer_secret')->get();
        $data = AppOffer::where('status', '!=', 1)->orderBy('id', 'DESC')->paginate();
        return view('offer.active',['data'=>$data,'sign'=>$sign[0]->offer_secret]);
    }


    public function indexComplete()
    {
        
        $data = AppOffer::where('status',1)->orderBy('id', 'DESC')->paginate();
        return view('offer.completed', compact('data'));
    }
    
    public function cpeadlead_offers(){
         if(isset(request()->c) && request()->c!=null){
            $url = 'https://cpalead.com/dashboard/reports/campaign_json.php?id=1406515&offerwall_offers=true&country='.request()->c.'&device=android&format=JSON';
        }else{
            $url = 'https://cpalead.com/dashboard/reports/campaign_json.php?id=1406515&offerwall_offers=true&country=IN&device=android&format=JSON';
        }
         $json= file_get_contents($url);
         $data = json_decode($json,true);
         
         if($data['offers']){
            $offers = $data['offers'];
         }else{
            $offers=$data->offers; 
         }
         
         $count =count($offers);
         
         $app=array();
         for($i=0; $i<$count; $i++){
             
            $app[$i]['campid']=$offers[$i]['campid'];
            $app[$i]['title']=$offers[$i]['title'];
            $app[$i]['description']=$offers[$i]['description'];
            $app[$i]['link']=$offers[$i]['link'];
            $app[$i]['amount']=$offers[$i]['amount'];
            $app[$i]['payout_currency']=$offers[$i]['payout_currency'];
            $app[$i]['payout_type']=$offers[$i]['payout_type'];
            $app[$i]['category_name']=$offers[$i]['category_name'];
            $app[$i]['conversion']=$offers[$i]['conversion'];
            $app[$i]['country']=$offers[$i]['country'];
            $app[$i]['traffic_type']=$offers[$i]['traffic_type'];
            $app[$i]['epc']=$offers[$i]['epc'];
            
            if(isset($offers[$i]['creatives'][0]['url'])){
                $app[$i]['image']=$offers[$i]['creatives'][0]['url'];
            }else{
                foreach($offers[$i]['creatives'] as $item){
                   $app[$i]['image']=$item->url; 
                }
            }
            
         }
         ;
         $country=DB::table('country')->get();
         
         return view('offer/cpalead_offer',['data'=>$app,'cn'=>$country]);
           
    }
    
    public function offertoro_offers(){
        $db = DB::table('admin_key')->where('id',1)->select('offertoro_appid','offertoro_pubid','offertoro_secret')->get();

        if($db[0]->offertoro_appid==null || $db[0]->offertoro_pubid=='{Your_pubid}' || $db[0]->offertoro_secret==null ){
            return view('offer/offertoro',['data'=>[],'cn'=>[],'db'=>$db]);
      
        }else{

            if(isset(request()->c) && request()->c!=null){
                $url = 'http://www.offertoro.com/api/?pubid='.$db[0]->offertoro_pubid.'&appid='.$db[0]->offertoro_appid.'&secretkey='.$db[0]->offertoro_secret.'&platform=ALL&device=android&format=json&country='.request()->c;
            }else{
                $url = 'http://www.offertoro.com/api/?pubid='.$db[0]->offertoro_pubid.'&appid='.$db[0]->offertoro_appid.'&secretkey='.$db[0]->offertoro_secret.'&platform=ALL&device=android&format=json&country=IN';
            }
            $json= file_get_contents($url);
            $data = json_decode($json,true);
            $offers=$data['response']['offers']; 

            $country=DB::table('country')->get();
            
            return view('offer/offertoro',['data'=>$offers,'cn'=>$country,'db'=>$db]);
        }
           
    }
    
    public function updateSetting(Request $req){
        $db = DB::table('admin_key')->where('id',1)->update(['offertoro_appid'=>$req->offertoro_appid,'offertoro_pubid'=>$req->offertoro_pubid,'offertoro_secret'=>$req->offertoro_secret]);
        return redirect('/offers/offertoro_offers')->with('success', 'Updated Successfully!');
    }

    public function edit(AppOffer $id)
    {
        $data = $id;
        return view('offer/edit', compact('data'));
    }

    public function create()
    {
        return view('offer.add');
    }
    
    public function addcpi(Request $req){
        return view('offer/addoffer',['data'=>$req]);
    }

    public function store(Request $req)
    {
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        // return $req;
        if($req->offer_type=="offer_toro"){
            $app = new AppOffer;
            $app->app_name = $req->app_name;
            $app->image = $req->image;
            $app->points = $req->points;
            $app->appurl = $req->appurl;
            $app->appID = $req->appID;
            $app->payout = $req->payout;
            $app->expire_at = $req->expired_at;
            $app->offer_id = $req->id;
            $app->offer_type = $req->offer_type;
            $app->country = $req->country;
            $app->p_userid = $req->p_userid;
            $app->response_code = $req->response_code;
            $app->task_limit = $req->task_limit;
            $app->details = $req->details;
            $res=$app->save();
            
            if ($res) {
                return redirect('/offers/offertoro_offers')->with('success', ' Added Successfully!');
            } else {
                return redirect('/offers/offertoro_offers')->with('error', 'Technical Error!');
            }
            
        }else{
            $app = new AppOffer;
            $app->app_name = $req->app_name;
            $app->image = $req->image;
            $app->points = $req->points;
            $app->appurl = $req->appurl;
            $app->appID = $req->appID;
            $app->country = $req->country;
            $app->payout = $req->payout;
            $app->expire_at = $req->expired_at;
            $app->p_userid = $req->p_userid;
            $app->response_code = $req->response_code;
            $app->task_limit = $req->task_limit;
            $app->details = $req->details;
            $res=$app->save();
    
            if ($res) {
                return redirect('/offers/active')->with('success', ' Created Successfully!');
            } else {
                return redirect('/offers/add')->with('error', 'Technical Error!');
            }
        }
        
        
    }

    public function update(Request $req)
    {
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        $app = AppOffer::find($req->id);
        $app->app_name = $req->app_name;
        $app->image = $req->image;
        $app->points = $req->points;
        $app->appurl = $req->appurl;
        $app->country = $req->country;
        $app->appID = $req->appID;
        $app->p_userid = $req->p_userid;
        $app->payout = $req->payout;
        $app->expire_at = $req->expired_at;
        $app->task_limit = $req->task_limit;
        $app->response_code = $req->response_code;
        $app->details = $req->details;
        $res=$app->save();

        if ($res) {
            return redirect('/offers/active')->with('success', ' Update Successfully!');
        } else {
            return redirect('/offers/add')->with('error', 'Technical Error!');
        }
    }


    public function destroy($id)
    {
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }
        AppOffer::where('id', $id)->delete();
        return 1;
    }

    public function action(Request $req)
    {

        if ($req->status == "delete") {
            if(auth()->user()->role_delete=='false'){
                return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
            }
            
            $update = AppOffer::whereIn('id', explode(",", $req->id))->delete();
            DB::table('appslog')->whereIn('appid',explode(",", $req->id))->delete();
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "enable") {
            if(auth()->user()->role_delete=='false'){
                return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
            }
            $update = AppOffer::whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            
            if(auth()->user()->role_delete=='false'){
                return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
            }
            $update = AppOffer::whereIn('id', explode(",", $req->id))->update(['status' => 2]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }
    }
}
