<?php

namespace App\Http\Controllers;

use App\Models\Users;
use App\Http\Controllers\Fun;
use App\Models\_Contest;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;

class Contest extends Controller
{

    public function index()
    {
         $data = _Contest::orderBy('task_require', 'ASC')->paginate();
        return view('contest/index', compact('data'));
    }
    
    public function contest_report()
    {
        $data = DB::table('contest_completed')->
                join('customer','customer.cust_id','=','contest_completed.user_id')
                ->leftJoin('contest_task','contest_task.id','=','contest_completed.contest_id')
                ->select('contest_completed.*','customer.name','contest_task.title_en')
                ->orderBy('id','DESC')->paginate();

        return view('contest/report', compact('data'));
    }
    
    
    public function add()
    {
        return view('contest/add');
    }

    public function store(Request $req)
    {
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>env('PERMISSION_ERROR')]);
        }
        
        if($req->type=="refer"){
            if($req->start_from==null || $req->expired_at==null){
                return redirect('/contest/add')->with('error', 'Please Select Valid Start and Ending Date Ran!');
            }
        }
        
       if($req->icon){
          $filename=  Fun::StoreImage("image",null,null,$req,"icon",false);
          if($filename==null){
             return redirect('/contest/add')->with('error', 'Technical Error in Image Upload');
          }
        }else{
            return redirect('/contest/add')->with('error', 'Please Select Valid Image!');
        }
        
        $actask= new _Contest;
        $actask->type=$req->type;
        $actask->title_en=$req->title_en;
        $actask->title_ar=$req->title_ar;
        $actask->title_in=$req->title_in;
        $actask->title_fr=$req->title_fr;
        $actask->title_de=$req->title_de;
        $actask->title_es=$req->title_es;
        $actask->title_vi=$req->title_vi;
        $actask->title_it=$req->title_it;
        $actask->title_bn=$req->title_bn;
        
        if($req->type=="refer"){
            $actask->start_from=$req->start_from;
            $actask->expired_at=$req->expired_at;
        }
        
        $actask->image=$filename;
        $actask->task_require=$req->task_require;
        $actask->coin=$req->coin;
        $res=$actask->save();

        if ($res) {
            return redirect('/contest')->with('success', 'Added Successfully!');
        } else {
            return redirect('/contest')->with('error', 'Technical Error!');
        }
    }


    public function edit(_Contest $id)
    {
        return view('contest/edit',['data'=>$id]);
    }

    public function update(Request $req)
    {
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        if($req->icon){
          $filename=  Fun::StoreImage("image",null,null,$req,"icon",true);
          if($filename==null){
             return redirect('/contest')->with('error', 'Technical Error in Image Upload');
          }
        }else{
           $filename=$req->oldicon; 
        }
      
        $actask= _Contest::find($req->id);
        $actask->type=$req->type;
        $actask->title_en=$req->title_en;
        $actask->title_ar=$req->title_ar;
        $actask->title_in=$req->title_in;
        $actask->title_fr=$req->title_fr;
        $actask->title_de=$req->title_de;
        $actask->title_es=$req->title_es;
        $actask->title_vi=$req->title_vi;
        $actask->title_it=$req->title_it;
        $actask->title_bn=$req->title_bn;
        $actask->image=$filename;
        $actask->task_require=$req->task_require;
        
        if($req->type=="refer"){
            $actask->start_from=$req->start_from;
            $actask->expired_at=$req->expired_at;
        }
        
        $actask->coin=$req->coin;
        $res=$actask->save();

        if ($res) {
            return redirect('/contest')->with('success', 'Update Successfully!');
        } else {
            return redirect('/contest')->with('error', 'Technical Error!');
        }
       
    }
    
    public function destroy($id)
    {
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }
        
        _Contest::find($id)->delete();
        DB::table('contest_completed')->where('contest_id',$id)->delete();
        return 1;
    }

    public function action(Request $req)
    {
        if(auth()->user()->role_edit=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        if ($req->status == "enable") {
            $update = _Contest::whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            $update = _Contest::whereIn('id', explode(",", $req->id))->update(['status' => 1]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }
    }




}