<?php

namespace App\Http\Controllers;

use App\Models\Users;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Image;
use File;
use Carbon\Carbon;

class CoinStore extends Controller
{

    //coinstore
    public function indexStore()
    {
        $data = DB::table('coinstore')->orderBy('id')->paginate();
        return view('coinstore/coinstore', compact('data'));
    }
    
    public function paymentTransaction()
    {
        if(isset(request()->type) && request()->type!='All'){
             $data = DB::table('payment_transaction')->
                join('customer','customer.cust_id','=','payment_transaction.userid')
                ->select('payment_transaction.*','customer.name')
                ->where('payment_transaction.type',0)
                ->where('payment_transaction.model_id',request()->type)
                ->orderBy('id','DESC')->paginate();
        }else{
              $data = DB::table('payment_transaction')->
                join('customer','customer.cust_id','=','payment_transaction.userid')
                ->select('payment_transaction.*','customer.name')
                ->where('payment_transaction.type','0')
                ->orderBy('id','DESC')->paginate();
        }
        
        $pac=DB::table('coinstore')->get();
        return view('coinstore/payment_transaction',['data'=>$data,'pac'=>$pac]);
    }

    public function storeCoin(Request $req)
    {
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        $data = DB::table('coinstore')->insert([
            'title' => $req->title,
            'amount' => $req->amount,
            'currency' => $req->currency,
            'currency_posi' => $req->currency_posi,
            'coin' => $req->coin,
            'productID' => 'inapp_'. uniqid(),
            'country' => $req->country
        ]);

        if ($data) {
            return redirect('/coinstore')->with('success', 'Added Successfully!');
        } else {
            return redirect('/coinstore')->with('error', 'Technical Error!');
        }
    }
    
    public function pendingApproval(){
        $sub = DB::table('coinstore')->orderBy('id', 'DESC')->paginate();
      
        if(isset(request()->type) && request()->type!='All'){
             $data = DB::table('payment_proof')->
                join('customer','customer.cust_id','=','payment_proof.user_id')
                ->select('payment_proof.*','customer.name')
                ->where(['payment_proof.model_type'=>0,'payment_proof.model_id'=>request()->type,'payment_proof.status'=>0])
                ->orderBy('id','DESC')->paginate();
        }else{
              $data = DB::table('payment_proof')->
                join('customer','customer.cust_id','=','payment_proof.user_id')
                ->select('payment_proof.*','customer.name')
                ->where(['payment_proof.model_type'=>0,'payment_proof.status'=>0])
                ->orderBy('id','DESC')->paginate();
        }
        
        return view('coinstore/pending',['data'=>$data,'sub'=>$sub]);
    }
    
    public function ApprovedOfflinePayment(){
        if(isset(request()->type) && request()->type!=''){
             $data = DB::table('payment_proof')->
                join('customer','customer.cust_id','=','payment_proof.user_id')
                ->select('payment_proof.*','customer.name')
                ->where(['payment_proof.model_type'=>0,'payment_proof.model_id'=>request()->type,'payment_proof.status'=>request()->type])
                ->orderBy('id','DESC')->paginate();
        }else{
              $data = DB::table('payment_proof')->
                join('customer','customer.cust_id','=','payment_proof.user_id')
                ->select('payment_proof.*','customer.name')
                ->where(['payment_proof.model_type'=>'0','payment_proof.status'=>1])
                ->orderBy('id','DESC')->paginate();
        }
        
        return view('subscriptions/approved',['data'=>$data]);
    }
    
    public function coinApproval($id){
        
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        $paytrans=DB::table('payment_proof')->where('id',$id)->get();
        
        $coin=DB::table('coinstore')->where('id',$paytrans[0]->model_id)->get();
        $user=Users::find($paytrans[0]->user_id);
        
        // updating user
        $total=$user->promo_balance+$coin[0]->coin;
        $user->promo_balance= $total;
        $user->save();
      
        DB::table('payment_transaction')->insert([
            'userid' => $user->cust_id,
            'method' => $paytrans[0]->payment_modal,
            'trans_id' =>$paytrans[0]->transaction_id ,
            'amount' => ($coin[0]->currency_posi == 0) ? $coin[0]->currency . ' ' . $coin[0]->amount : $coin[0]->amount . ' ' . $coin[0]->currency,
            'status' => 'approved',
            'model_id' => $paytrans[0]->model_id,
            'type' => 0,
            'pacinfo' => $paytrans[0]->modal_info
        ]);
         
         DB::table('transaction')
                ->insert([
                    'tran_type' => 'credit',
                    'user_id' =>$paytrans[0]->user_id,
                    'amount' => $coin[0]->coin,
                    'type' => 'Promo Coin',
                    'remained_balance' => $total,
                    'inserted_at' => Carbon::now(),
                    'remarks' =>'Promo Coin Purchased'
                ]);
        
        DB::table('payment_proof')->where('id',$id)->update(['status'=>1,'updated_at'=>Carbon::now()]);
        
        DB::table('tbl_noti')->insert([
            'user_id'=>$paytrans[0]->user_id,
            'title'=>'Congratulations',
            'msg'=>$coin[0]->coin.' Added to your promo wallet. Thanks for purchasing',
            'noti_type'=>0
            ]);
            
        DB::table('global_msg')->insert([
            'user_id'=>$paytrans[0]->user_id,
            'title'=>'Congratulations',
            'msg'=>$coin[0]->coin.' Added to your promo wallet. Thanks for purchasing',
            'btn_name'=>'Start Promotion',
            'btn_action'=>'promo',
            'error'=>'false'
            ]); 
        
        return redirect('/coinstore/pending-approval')->with('success','Update Successfully !');
        
    }
    
    public function coinReject(Request $req){
        
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        $paytrans=DB::table('payment_proof')->where('id',$req->id)->get();
        
        $coin=DB::table('coinstore')->where('id',$paytrans[0]->model_id)->get();

        DB::table('payment_proof')->where('id',$req->id)->update(['status'=>2,'updated_at'=>Carbon::now()]);
        
        DB::table('tbl_noti')->insert([
            'user_id'=>$paytrans[0]->user_id,
            'title'=>$coin[0]->title.' Payment has been Rejected',
            'msg'=>$req->remark,
            'noti_type'=>0
            ]);
        
        DB::table('global_msg')->insert([
            'user_id'=>$paytrans[0]->user_id,
            'title'=>$coin[0]->title.' Payment has been Rejected',
            'msg'=>$req->remark,
            'btn_name'=>'Submit Again',
            'btn_action'=>'coinstore',
            'error'=>'true'
            ]); 
            
        return redirect('/coinstore/pending-approval')->with('success','Payment Rejected Successfully !');
    }

    public function editStore($id)
    {
        return DB::table('coinstore')->where('id', $id)->get();
    }

    public function updateStore(Request $req)
    {
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        $data = DB::table('coinstore')->where('id', $req->id)->update([
            'title' => $req->title,
            'amount' => $req->amount,
            'currency' => $req->currency,
            'currency_posi' => $req->currency_posi,
            'productID' => 'inapp_'. uniqid(),
            'coin' => $req->coin,
            'country' => $req->country
        ]);

        if ($data) {
            return redirect('/coinstore')->with('success', 'Update Successfully!');
        } else {
            return redirect('/coinstore')->with('error', 'Technical Error!');
        }
    }

    public function destroyStore($id)
    {
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        DB::table('coinstore')->where('id', $id)->delete();
        return 1;
    }

    public function actionStore(Request $req)
    {
        if(auth()->user()->role_edit=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        if ($req->status == "enable") {
            $update = DB::table('coinstore')->whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            $update = DB::table('coinstore')->whereIn('id', explode(",", $req->id))->update(['status' => 1]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }
    }
    
    
}
