<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use App\Models\Users;
use App\Models\Slider;
use App\Models\MOfferwall;
use App\Models\Video;
use App\Models\Web;
use App\Models\Task;
use App\Models\CoinStore;
use App\Models\Transaction;
use App\Models\Weblink;
use App\User;
use Carbon\Carbon;
use GeoIP;
use Tymon\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Storage;
use File, Image;


class Off extends Controller
{

  public function crofferwall($id, Request $req)
    {
        $db = DB::table('admin_key')->where('id',1)->select('offer_secret')->get();
        if ($req->signs != $db[0]->offer_secret) {
            return 'Invalid Key';
        }
        
        $now = Carbon::now();

        if ($offerwall=MOfferwall::where('id',$id)->first()) {
            
            $userid=$req->query($this->clean($offerwall->p_userid));
            $coin=$req->query($this->clean($offerwall->p_payout));
            $offerid=$req->query($this->clean($offerwall->p_campaing_id));
            $usdAmount=$req->query($this->clean($offerwall->p_admin_payout));
            $offername=$req->query($this->clean($offerwall->p_offername));
            $ip=$req->query($this->clean($offerwall->p_ip));
                
            $cntra=DB::table('offerwall_earing')->where(['user_id' => $userid,'offerwall_id'=>$id,'survey_id' => $offerid])->count();

            if($cntra>0){
                return ':Coin Already Credited';
            }
            
            if ($offername == "") {
                $offername = "offer completed";
            }
            
            if ($ip == "") {
                $ip = "blank";
            }
            
            if($user=Users::find($userid)){
                
                $currentcoin = $user->balance;
                $total = $currentcoin + $coin;
                $trns = DB::table('transaction')
                    ->insert([
                        'tran_type' => 'credit',
                        'user_id' => $userid,
                        'amount' => $coin,
                        'ip' => $ip,
                        'eventId' => $offerid,
                        'type' => $offername . ' Credit',
                        'remained_balance' => $total,
                        'offerwall_type' => $offerwall->offerwall_slug,
                        'admin_remarks' =>"$".$usdAmount."  Admin Earned",
                        'remarks' => $offername .'Completed'
                    ]);
                $user->balance = $total;
                $user->save();
    
                DB::table('tbl_noti')->insert(['user_id' => $userid, 'title' => $coin . ' Bonus Received', 'msg' => $offername . ' Completed', 'created_at' => Carbon::now()]);
                
                  DB::table('offerwall_earing')->insert([
                        'earning'=>$usdAmount,
                        'offerwall_name'=>$offerwall->offerwall_slug,
                        'offerwall_id'=>$id,
                        'user_id'=>$userid,
                        'remark'=>$offername .'Completed',
                        'survey_id'=>$offerid]);
               
                    return $offerwall->response_code; 
            }else{
                return 'Invalid Data';
            }

        }else{
            return 'Invalid Offerwall Data';
        }
    }
    
    public function offer_custom(Request $req)
    {

        $db = DB::table('admin_key')->where('id',1)->select('offer_secret')->get();
        if ($req->signs != $db[0]->offer_secret) {
            return 'Invalid Key';
        }

        if (isset($req->subid2)) {
            $id = $req->subid2;
            $appID = 0;
        } else if (isset($req->offerid)) {
            $id = $req->offerid;
            $appID = 1;
        } else if (isset($req->appid)) {
            $id = $req->appid;
            $appID = 2;
        } else if (isset($req->offer_id)) {
            $id = $req->offer_id;
            $appID = 3;
        } else {
            return response()->json('Invalid Configuration ');
        }

        $app = AppOffer::find($id);
        if ($app) {
            if ($app->appID != $appID) {
                 return response()->json('Invalid App ID Type');
            }

            $prm = str_replace('=', '', $app->p_userid);
            $uid = $req->$prm;

            $ad = DB::table('appslog')->where(['user_id' => $uid, 'appid' => $id])->get();
            
            if($user = Users::find($uid)){
                if ($ad) {
                    if ($ad[0]->status == "1") {
                        $total = $user->balance + $app->points;
                        $user->balance = $total;
                        $user->save();
    
                        $app->views += +1;
                        if ($app->task_limit != "0") {
                            if (($app->views += +1) >=  $app->task_limit) {
                                $app->status = 1;
                            }
                        }
                        $app->save();
                        DB::table('appslog')->where(['user_id' => $uid, 'appid' => $id])->update(['status' => 0]);
    
                        DB::table('transaction')
                            ->insert([
                                'tran_type' => 'credit',
                                'user_id' => $uid,
                                'amount' => $app->points,
                                'type' => 'Offers',
                                'remained_balance' => $total,
                                'remarks' => $app->app_name . ' Completed'
                            ]);
    
                        DB::table('tbl_noti')->insert(['user_id' => $uid, 'title' => $app->points . ' Bonus Received', 'msg' => $app->app_name . ' Completed', 'created_at' => Carbon::now()]);
    
    
                   return response()->json($app->response_code);
                    } else {
                       return response()->json('Already Creited');
                    }
                } else {
                    
                    $total = $user->balance + $app->points;
                    $user->balance = $total;
                    $user->save();
    
                    $app->views += +1;
                    if ($app->task_limit != "0") {
                        if (($app->views += +1) >=  $app->task_limit) {
                            $app->status = 1;
                        }
                    }
                    $app->save();
                    DB::table('appslog')->insert(['user_id' => $uid, 'appid' => $id, 'status' => 0]);
    
                    DB::table('transaction')
                        ->insert([
                            'tran_type' => 'credit',
                            'user_id' => $uid,
                            'amount' => $app->points,
                            'type' => 'Offers',
                            'remained_balance' => $total,
                            'remarks' => $app->app_name . ' Completed'
                        ]);
                    DB::table('tbl_noti')->insert(['user_id' => $uid, 'title' => $app->points . ' Bonus Received', 'msg' => $app->app_name . ' Completed', 'created_at' => Carbon::now()]);
    
                     return response()->json($app->response_code);
                }
            }else{
                    return 'User Not Exist';
            }

        } else {
            return response()->json('Offer Not Found');
        }
    }

 
    function clean($string) {
      $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
      return preg_replace('/[^\w\-_]/', '', $string); // Removes special chars.
    }
}