import { GraphQLInputObjectType } from './graphql';
import { TypeInPath } from './utils/typeByPath';
import type { ThunkWithSchemaComposer, ObjMap, Extensions, Directive, DirectiveArgs } from './utils/definitions';
import { SchemaComposer } from './SchemaComposer';
import { ListComposer } from './ListComposer';
import { NonNullComposer } from './NonNullComposer';
import type { ThunkComposer } from './ThunkComposer';
import type { TypeAsString, TypeDefinitionString } from './TypeMapper';
import type { GraphQLInputFieldConfig, GraphQLInputType, InputValueDefinitionNode } from './graphql';
import { NamedTypeComposer, ComposeInputType, ComposeNamedInputType, ComposeInputTypeDefinition } from './utils/typeHelpers';
import { SchemaPrinterOptions } from './utils/schemaPrinter';
export declare type InputTypeComposerDefinition = TypeAsString | TypeDefinitionString | InputTypeComposerAsObjectDefinition | Readonly<GraphQLInputObjectType>;
export declare type InputTypeComposerAsObjectDefinition = {
    name: string;
    fields: ThunkWithSchemaComposer<InputTypeComposerFieldConfigMapDefinition, SchemaComposer<any>>;
    description?: null | string;
    extensions?: Extensions;
    directives?: Directive[];
};
export declare type InputTypeComposerFieldConfigMap = ObjMap<InputTypeComposerFieldConfig>;
export declare type InputTypeComposerFieldConfigMapDefinition = ObjMap<InputTypeComposerFieldConfigDefinition>;
export declare type InputTypeComposerFieldConfigDefinition = ThunkWithSchemaComposer<InputTypeComposerFieldConfigAsObjectDefinition, SchemaComposer<any>> | ThunkWithSchemaComposer<ComposeInputTypeDefinition, SchemaComposer<any>>;
export declare type InputTypeComposerFieldConfigAsObjectDefinition = {
    type: ThunkWithSchemaComposer<ComposeInputTypeDefinition, SchemaComposer<any>>;
    defaultValue?: unknown;
    description?: string | null;
    extensions?: Extensions;
    directives?: Directive[];
    [key: string]: unknown;
};
export declare type InputTypeComposerFieldConfig = {
    type: ComposeInputType;
    defaultValue?: unknown;
    description?: string | null;
    astNode?: InputValueDefinitionNode | null;
    extensions?: Extensions;
    directives?: Directive[];
    [key: string]: unknown;
};
export declare type InputTypeComposerThunked<TContext> = InputTypeComposer<TContext> | ThunkComposer<InputTypeComposer<TContext>, GraphQLInputType>;
export declare class InputTypeComposer<TContext = any> {
    schemaComposer: SchemaComposer<TContext>;
    _gqType: GraphQLInputObjectType;
    _gqcFields: InputTypeComposerFieldConfigMap;
    _gqcExtensions?: Extensions;
    _gqcDirectives?: Directive[];
    _gqcIsModified?: boolean;
    static create<TCtx = any>(typeDef: InputTypeComposerDefinition, schemaComposer: SchemaComposer<TCtx>): InputTypeComposer<TCtx>;
    static createTemp<TCtx = any>(typeDef: InputTypeComposerDefinition, schemaComposer?: SchemaComposer<TCtx>): InputTypeComposer<TCtx>;
    constructor(graphqlType: GraphQLInputObjectType, schemaComposer: SchemaComposer<TContext>);
    getFields(): InputTypeComposerFieldConfigMap;
    getFieldNames(): string[];
    hasField(fieldName: string): boolean;
    setFields(fields: InputTypeComposerFieldConfigMapDefinition): this;
    setField(fieldName: string, fieldConfig: InputTypeComposerFieldConfigDefinition): this;
    addFields(newFields: InputTypeComposerFieldConfigMapDefinition): this;
    addNestedFields(newFields: InputTypeComposerFieldConfigMapDefinition): this;
    getField(fieldName: string): InputTypeComposerFieldConfig;
    removeField(fieldNameOrArray: string | string[]): this;
    removeOtherFields(fieldNameOrArray: string | string[]): this;
    extendField(fieldName: string, partialFieldConfig: Partial<InputTypeComposerFieldConfigAsObjectDefinition>): this;
    reorderFields(names: string[]): this;
    getFieldConfig(fieldName: string): GraphQLInputFieldConfig;
    getFieldType(fieldName: string): GraphQLInputType;
    getFieldTypeName(fieldName: string): string;
    getFieldTC(fieldName: string): ComposeNamedInputType<TContext>;
    getFieldITC(fieldName: string): InputTypeComposer<TContext>;
    isRequired(fieldName: string): boolean;
    isFieldNonNull(fieldName: string): boolean;
    makeFieldNonNull(fieldNameOrArray: string | string[]): this;
    makeRequired(fieldNameOrArray: string | string[]): this;
    makeFieldNullable(fieldNameOrArray: string | string[]): this;
    makeOptional(fieldNameOrArray: string | string[]): this;
    isFieldPlural(fieldName: string): boolean;
    makeFieldPlural(fieldNameOrArray: string | string[]): this;
    makeFieldNonPlural(fieldNameOrArray: string | string[]): this;
    getType(): GraphQLInputObjectType;
    getTypePlural(): ListComposer<InputTypeComposer<TContext>>;
    getTypeNonNull(): NonNullComposer<InputTypeComposer<TContext>>;
    get List(): ListComposer<InputTypeComposer<TContext>>;
    get NonNull(): NonNullComposer<InputTypeComposer<TContext>>;
    getTypeName(): string;
    setTypeName(name: string): this;
    getDescription(): string;
    setDescription(description: string): this;
    clone(newTypeNameOrTC: string | InputTypeComposer<any>): InputTypeComposer<TContext>;
    cloneTo(anotherSchemaComposer: SchemaComposer<any>, cloneMap?: Map<any, any>): InputTypeComposer<any>;
    merge(type: GraphQLInputObjectType | InputTypeComposer<any>): this;
    getExtensions(): Extensions;
    setExtensions(extensions: Extensions | undefined): this;
    extendExtensions(extensions: Extensions): this;
    clearExtensions(): this;
    getExtension(extensionName: string): unknown;
    hasExtension(extensionName: string): boolean;
    setExtension(extensionName: string, value: unknown): this;
    removeExtension(extensionName: string): this;
    getFieldExtensions(fieldName: string): Extensions;
    setFieldExtensions(fieldName: string, extensions: Extensions): this;
    extendFieldExtensions(fieldName: string, extensions: Extensions): this;
    clearFieldExtensions(fieldName: string): this;
    getFieldExtension(fieldName: string, extensionName: string): unknown;
    hasFieldExtension(fieldName: string, extensionName: string): boolean;
    setFieldExtension(fieldName: string, extensionName: string, value: unknown): this;
    removeFieldExtension(fieldName: string, extensionName: string): this;
    getDirectives(): Array<Directive>;
    setDirectives(directives: Array<Directive>): this;
    getDirectiveNames(): string[];
    getDirectiveByName(directiveName: string): DirectiveArgs | undefined;
    setDirectiveByName(directiveName: string, args?: DirectiveArgs): this;
    getDirectiveById(idx: number): DirectiveArgs | undefined;
    getFieldDirectives(fieldName: string): Array<Directive>;
    setFieldDirectives(fieldName: string, directives: Array<Directive> | undefined): this;
    getFieldDirectiveNames(fieldName: string): string[];
    getFieldDirectiveByName(fieldName: string, directiveName: string): DirectiveArgs | undefined;
    setFieldDirectiveByName(fieldName: string, directiveName: string, args?: DirectiveArgs): this;
    getFieldDirectiveById(fieldName: string, idx: number): DirectiveArgs | undefined;
    get(path: string | string[]): TypeInPath<TContext> | void;
    getNestedTCs(opts?: {
        exclude?: string[] | null;
    }, passedTypes?: Set<NamedTypeComposer<any>>): Set<NamedTypeComposer<any>>;
    toSDL(opts?: SchemaPrinterOptions & {
        deep?: boolean;
        exclude?: string[];
    }): string;
}
//# sourceMappingURL=InputTypeComposer.d.ts.map