import { useEnv } from '@directus/env';
import { SchemaHelper } from '../types.js';
import { preprocessBindings } from '../utils/preprocess-bindings.js';
const env = useEnv();
export class SchemaHelperPostgres extends SchemaHelper {
    async getDatabaseSize() {
        try {
            const result = await this.knex.select(this.knex.raw(`pg_database_size(?) as size;`, [env['DB_DATABASE']]));
            return result[0]?.['size'] ? Number(result[0]?.['size']) : null;
        }
        catch {
            return null;
        }
    }
    preprocessBindings(queryParams) {
        return preprocessBindings(queryParams, { format: (index) => `$${index + 1}` });
    }
}
